/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.internal.Strings;
import java.util.EnumSet;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

enum LifecyclePhase {
    BEFORE_FIRST_USE,
    BEFORE_MIGRATE,
    AFTER_MIGRATE,
    BEFORE_CLEAN,
    AFTER_CLEAN,
    BEFORE_VALIDATE,
    AFTER_VALIDATE,
    BEFORE_INFO,
    AFTER_INFO;

    private static final EnumSet<LifecyclePhase> ALL_VALUES;
    static final Pattern LIFECYCLE_PATTERN;

    static boolean canParse(String pathOrUrl) {
        return LIFECYCLE_PATTERN.matcher(pathOrUrl).find();
    }

    static LifecyclePhase fromCamelCase(String value) {
        return ALL_VALUES.stream().filter(phase -> phase.toCamelCase().equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException("No such lifecycle phase: " + value));
    }

    String toCamelCase() {
        return Strings.toCamelCase(this.name());
    }

    String readable() {
        return this.name().toLowerCase(Locale.ENGLISH).replace("_", " ");
    }

    static {
        ALL_VALUES = EnumSet.allOf(LifecyclePhase.class);
        String group1 = ALL_VALUES.stream().map(LifecyclePhase::toCamelCase).collect(Collectors.joining("|", "(", ")"));
        LIFECYCLE_PATTERN = Pattern.compile(group1 + "(?:__([\\w ]+))?(?:\\.cypher)?");
    }
}

