/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationsException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public final class Location {
    private final LocationType type;
    private final String name;

    public static Location of(String uri) {
        LocationType type;
        int indexOfFirstColon = uri.indexOf(":");
        if (indexOfFirstColon < 0) {
            return new Location(LocationType.CLASSPATH, uri);
        }
        String prefix = uri.substring(0, indexOfFirstColon).toLowerCase(Locale.ENGLISH).trim();
        String name = uri.substring(indexOfFirstColon + 1).trim().replace('\\', '/');
        if (name.isEmpty()) {
            throw new MigrationsException("Invalid location: '" + uri + "'");
        }
        if (LocationType.CLASSPATH.getPrefix().equals(prefix)) {
            type = LocationType.CLASSPATH;
        } else if (LocationType.FILESYSTEM.getPrefix().equals(prefix)) {
            type = LocationType.FILESYSTEM;
            name = URI.create(String.format("%s:%s", prefix, name)).getPath();
        } else {
            String supportedSchemes = Arrays.stream(LocationType.values()).map(LocationType::getPrefix).map(s -> String.format("'%s:'", s)).collect(Collectors.joining(", "));
            throw new MigrationsException("Invalid scheme: '" + prefix + "', supported schemes are " + supportedSchemes);
        }
        if (name == null || name.length() == 0) {
            throw new MigrationsException("Invalid path; a valid file location must begin with either file:/path (no hostname), file:///path (empty hostname), or file://hostname/path");
        }
        return new Location(type, name);
    }

    private Location(LocationType type, String name) {
        this.type = type;
        this.name = name.startsWith("/") ? name : "/" + name;
    }

    public LocationType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    URI toUri() {
        try {
            return new URI(this.type.getPrefix(), "", this.name, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static enum LocationType {
        CLASSPATH("classpath"),
        FILESYSTEM("file");

        private final String prefix;

        private LocationType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

