/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractCypherBasedMigration;
import ac.simons.neo4j.migrations.core.Callback;
import ac.simons.neo4j.migrations.core.CatalogBasedMigration;
import ac.simons.neo4j.migrations.core.ChainBuilder;
import ac.simons.neo4j.migrations.core.ChainTool;
import ac.simons.neo4j.migrations.core.CleanResult;
import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.ConnectionDetailsFormatter;
import ac.simons.neo4j.migrations.core.DatabaseCatalog;
import ac.simons.neo4j.migrations.core.DefaultLifecycleEvent;
import ac.simons.neo4j.migrations.core.DeleteResult;
import ac.simons.neo4j.migrations.core.DiscoveryService;
import ac.simons.neo4j.migrations.core.HBD;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.LifecyclePhase;
import ac.simons.neo4j.migrations.core.Messages;
import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationState;
import ac.simons.neo4j.migrations.core.MigrationType;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.MigrationsLock;
import ac.simons.neo4j.migrations.core.Neo4jEdition;
import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.ProductVersion;
import ac.simons.neo4j.migrations.core.RepairmentResult;
import ac.simons.neo4j.migrations.core.ResourceBasedMigrationProvider;
import ac.simons.neo4j.migrations.core.ResourceContext;
import ac.simons.neo4j.migrations.core.StopWatch;
import ac.simons.neo4j.migrations.core.ValidationResult;
import ac.simons.neo4j.migrations.core.VersionedCatalog;
import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.Refactoring;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Node;

public final class Migrations {
    static final Logger LOGGER = Logger.getLogger(Migrations.class.getName());
    static final Logger STARTUP_LOGGER = Logger.getLogger(Migrations.class.getName() + ".Startup");
    static final String PROPERTY_MIGRATION_VERSION = "version";
    static final String PROPERTY_MIGRATION_TARGET = "migrationTarget";
    static final String PROPERTY_MIGRATION_DESCRIPTION = "description";
    static final Constraint UNIQUE_VERSION = Constraint.forNode("__Neo4jMigration").named("unique_version___Neo4jMigration").unique("version", "migrationTarget");
    private final MigrationsConfig config;
    private final Driver driver;
    private final MigrationContext context;
    private final DiscoveryService discoveryService;
    private final ChainBuilder chainBuilder;
    private volatile List<Migration> resolvedMigrations;
    private volatile Map<LifecyclePhase, List<Callback>> resolvedCallbacks;
    private final AtomicBoolean beforeFirstUseHasBeenCalled = new AtomicBoolean(false);

    public Migrations(MigrationsConfig config, Driver driver) {
        this.config = config;
        this.driver = driver;
        this.discoveryService = new DiscoveryService(this.config.getMigrationClassesDiscoverer(), this.config.getResourceScanner());
        this.chainBuilder = new ChainBuilder();
        this.context = MigrationContext.of(this.config, this.driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Migration> getMigrations() {
        List<Migration> availableMigrations = this.resolvedMigrations;
        if (availableMigrations == null) {
            Migrations migrations = this;
            synchronized (migrations) {
                availableMigrations = this.resolvedMigrations;
                if (availableMigrations == null) {
                    availableMigrations = this.resolvedMigrations = this.discoveryService.findMigrations(this.context);
                }
            }
        }
        return availableMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<LifecyclePhase, List<Callback>> getCallbacks() {
        Map<LifecyclePhase, List<Callback>> availableCallbacks = this.resolvedCallbacks;
        if (availableCallbacks == null) {
            Migrations migrations = this;
            synchronized (migrations) {
                availableCallbacks = this.resolvedCallbacks;
                if (availableCallbacks == null) {
                    availableCallbacks = this.resolvedCallbacks = this.discoveryService.findCallbacks(this.context);
                }
            }
        }
        return availableCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.resolvedMigrations != null || this.resolvedCallbacks != null) {
            Migrations migrations = this;
            synchronized (migrations) {
                this.resolvedMigrations = null;
                this.resolvedCallbacks = null;
            }
        }
    }

    public ConnectionDetails getConnectionDetails() {
        return this.context.getConnectionDetails();
    }

    public MigrationChain info() {
        return this.executeWithinLock(() -> this.chainBuilder.buildChain(this.context, this.getMigrations()), LifecyclePhase.BEFORE_INFO, LifecyclePhase.AFTER_INFO);
    }

    public MigrationChain info(MigrationChain.ChainBuilderMode mode) {
        return this.executeWithinLock(() -> this.chainBuilder.buildChain(this.context, this.getMigrations(), false, mode), LifecyclePhase.BEFORE_INFO, LifecyclePhase.AFTER_INFO);
    }

    public Optional<MigrationVersion> apply() {
        return this.apply(false);
    }

    public Optional<MigrationVersion> apply(boolean log) {
        return this.executeWithinLock(() -> {
            if (log && STARTUP_LOGGER.isLoggable(Level.INFO)) {
                STARTUP_LOGGER.info(() -> Messages.INSTANCE.format("startup_log", Migrations.getUserAgent(), ConnectionDetailsFormatter.INSTANCE.format(this.getConnectionDetails())));
            }
            this.apply0(this.getMigrations());
            return this.getLastAppliedVersion();
        }, LifecyclePhase.BEFORE_MIGRATE, LifecyclePhase.AFTER_MIGRATE);
    }

    public Counters apply(Refactoring ... refactorings) {
        if (refactorings == null || refactorings.length == 0) {
            return Counters.empty();
        }
        Neo4jVersion neo4jVersion = Neo4jVersion.of(this.context.getConnectionDetails().getServerVersion());
        Neo4jEdition neo4jEdition = Neo4jEdition.of(this.context.getConnectionDetails().getServerEdition());
        CatalogBasedMigration.OperationContext operationContext = new CatalogBasedMigration.OperationContext(neo4jVersion, neo4jEdition, (VersionedCatalog)this.context.getCatalog(), this.context::getSession);
        return ((Stream)Arrays.stream(refactorings).filter(Objects::nonNull).sequential()).map(CatalogBasedMigration.Operation::refactorWith).map(op -> op.execute(operationContext)).reduce(Counters.empty(), Counters::add);
    }

    public int apply(URL ... resources) {
        int cnt = 0;
        if (resources == null || resources.length == 0) {
            return cnt;
        }
        Map providers = ResourceBasedMigrationProvider.unique().stream().collect(Collectors.toMap(ResourceBasedMigrationProvider::getExtension, Function.identity()));
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        for (URL resource : resources) {
            if (resource == null) continue;
            String path = resource.getPath();
            Matcher matcher = MigrationVersion.VERSION_PATTERN.matcher(path);
            if (!matcher.find()) {
                throw new IllegalArgumentException(Messages.INSTANCE.format("errors.invalid_resource_name", path));
            }
            String ext = matcher.group("ext");
            if (!providers.containsKey(ext)) {
                throw new IllegalArgumentException(Messages.INSTANCE.format("errors.unsupported_extension", ext));
            }
            ResourceBasedMigrationProvider provider = (ResourceBasedMigrationProvider)providers.get(ext);
            migrations.addAll(provider.handle(ResourceContext.of(resource, this.config)));
        }
        for (Migration migration : migrations) {
            migration.apply(this.context);
            LOGGER.info(() -> "Applied " + Migrations.toString(migration));
            ++cnt;
        }
        return cnt;
    }

    public CleanResult clean(boolean all) {
        Optional<String> optionalMigrationTarget = this.config.getMigrationTargetIn(this.context);
        DeletedChainsWithCounters deletedChainsWithCounters = this.executeWithinLock(() -> this.clean0(optionalMigrationTarget, all), LifecyclePhase.BEFORE_CLEAN, LifecyclePhase.AFTER_CLEAN);
        long nodesDeleted = deletedChainsWithCounters.counter.nodesDeleted();
        long relationshipsDeleted = deletedChainsWithCounters.counter.relationshipsDeleted();
        long constraintsRemoved = (long)deletedChainsWithCounters.counter.constraintsRemoved() + deletedChainsWithCounters.additionalConstraintsRemoved;
        long indexesRemoved = 0L;
        if (all) {
            SummaryCounters additionalCounters = new MigrationsLock(this.context).clean();
            nodesDeleted += (long)additionalCounters.nodesDeleted();
            relationshipsDeleted += (long)additionalCounters.relationshipsDeleted();
            constraintsRemoved += (long)additionalCounters.constraintsRemoved();
            indexesRemoved += (long)additionalCounters.indexesRemoved();
        }
        return new CleanResult(this.config.getOptionalSchemaDatabase(), deletedChainsWithCounters.chainsDeleted, nodesDeleted, relationshipsDeleted, constraintsRemoved, indexesRemoved);
    }

    private DeletedChainsWithCounters clean0(Optional<String> migrationTarget, boolean all) {
        String query = "MATCH (n:__Neo4jMigration)\nWITH n, coalesce(n.migrationTarget, '<default>') as migrationTarget\nWHERE (migrationTarget = coalesce($migrationTarget,'<default>') OR $all)\nDETACH DELETE n\nRETURN DISTINCT migrationTarget\nORDER BY migrationTarget ASC\n";
        try (Session session = this.context.getSchemaSession();){
            DeletedChainsWithCounters deletedChainsWithCounters = (DeletedChainsWithCounters)session.executeWrite(tx -> {
                Result result = tx.run(query, Values.parameters((Object[])new Object[]{PROPERTY_MIGRATION_TARGET, migrationTarget.orElse(null), "all", all}));
                return new DeletedChainsWithCounters(result.list(r -> r.get(PROPERTY_MIGRATION_TARGET).asString()), result.consume().counters());
            });
            ConnectionDetails cd = this.context.getConnectionDetails();
            if (all && HBD.is44OrHigher(cd)) {
                Renderer<Constraint> renderer = Renderer.get(Renderer.Format.CYPHER, Constraint.class);
                RenderConfig dropConfig = RenderConfig.drop().ifExists().forVersionAndEdition(cd.getServerVersion(), cd.getServerEdition());
                DeletedChainsWithCounters deletedChainsWithCounters2 = new DeletedChainsWithCounters(deletedChainsWithCounters, session.run(renderer.render(UNIQUE_VERSION, dropConfig)).consume().counters().constraintsRemoved());
                return deletedChainsWithCounters2;
            }
            DeletedChainsWithCounters deletedChainsWithCounters3 = deletedChainsWithCounters;
            return deletedChainsWithCounters3;
        }
    }

    public DeleteResult delete(MigrationVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(Messages.INSTANCE.get("errors.version_required"));
        }
        return this.executeWithinLock(() -> {
            try (Session session = this.context.getSchemaSession();){
                DeleteResult deleteResult = (DeleteResult)session.executeWrite(tx -> {
                    Result result = tx.run(ChainTool.generateMigrationDeletionQuery(this.config.getMigrationTargetIn(this.context).orElse(null), version));
                    MigrationVersion deletedVersion = null;
                    if (result.hasNext()) {
                        Value properties = result.single().get("p");
                        deletedVersion = MigrationVersion.parse(properties.get("source").asString());
                    }
                    SummaryCounters counters = result.consume().counters();
                    return new DeleteResult(this.config.getOptionalSchemaDatabase().orElse(null), counters.nodesDeleted(), counters.nodesCreated(), counters.relationshipsDeleted(), counters.relationshipsCreated(), counters.propertiesSet(), deletedVersion);
                });
                return deleteResult;
            }
        }, null, null);
    }

    public RepairmentResult repair() {
        return this.executeWithinLock(() -> {
            String affectedDatabase = this.config.getOptionalSchemaDatabase().orElse(null);
            List<Migration> migrations = this.getMigrations();
            if (migrations.isEmpty()) {
                throw new MigrationsException("Zero migrations have been discovered and repairing the database would lead to the deletion of all migrations recorded; if you want that, use the clean operation");
            }
            ValidationResult validationResult = this.validate0();
            if (validationResult.isValid() || validationResult.getOutcome() == ValidationResult.Outcome.INCOMPLETE_DATABASE) {
                return RepairmentResult.unnecessary(affectedDatabase);
            }
            ChainBuilder nonVerifyingChainBuilder = new ChainBuilder(false);
            MigrationChain remoteChain = nonVerifyingChainBuilder.buildChain(this.context, migrations, true, MigrationChain.ChainBuilderMode.REMOTE);
            MigrationChain localChain = nonVerifyingChainBuilder.buildChain(this.context, migrations, true, MigrationChain.ChainBuilderMode.LOCAL);
            ChainTool chainTool = new ChainTool(migrations, localChain, remoteChain);
            long nodesDeleted = 0L;
            long nodesCreated = 0L;
            long relationshipsDeleted = 0L;
            long relationshipsCreated = 0L;
            long propertiesSet = 0L;
            try (Session session = this.context.getSchemaSession();
                 Transaction tx = session.beginTransaction(TransactionConfig.builder().build());){
                for (Query query : chainTool.repair(this.config, this.context)) {
                    SummaryCounters counters = tx.run(query).consume().counters();
                    nodesDeleted += (long)counters.nodesDeleted();
                    nodesCreated += (long)counters.nodesCreated();
                    relationshipsDeleted += (long)counters.relationshipsDeleted();
                    relationshipsCreated += (long)counters.relationshipsCreated();
                    propertiesSet += (long)counters.propertiesSet();
                }
                tx.commit();
            }
            return RepairmentResult.repaired(affectedDatabase, nodesDeleted, nodesCreated, relationshipsDeleted, relationshipsCreated, propertiesSet);
        }, null, null);
    }

    public ValidationResult validate() {
        return this.executeWithinLock(this::validate0, LifecyclePhase.BEFORE_VALIDATE, LifecyclePhase.AFTER_VALIDATE);
    }

    private ValidationResult validate0() {
        List<Migration> migrations = this.getMigrations();
        Optional<String> targetDatabase = this.config.getOptionalSchemaDatabase();
        try {
            MigrationChain migrationChain = new ChainBuilder(true).buildChain(this.context, migrations, true, MigrationChain.ChainBuilderMode.COMPARE);
            int numberOfAppliedMigrations = (int)migrationChain.getElements().stream().filter(m -> m.getState() == MigrationState.APPLIED).count();
            if (migrations.size() == numberOfAppliedMigrations) {
                return new ValidationResult(targetDatabase, ValidationResult.Outcome.VALID, numberOfAppliedMigrations == 0 ? Collections.singletonList("No migrations resolved.") : Collections.emptyList());
            }
            if (migrations.size() > numberOfAppliedMigrations) {
                return new ValidationResult(targetDatabase, ValidationResult.Outcome.INCOMPLETE_DATABASE, Collections.emptyList());
            }
            return new ValidationResult(targetDatabase, ValidationResult.Outcome.UNDEFINED, Collections.emptyList());
        }
        catch (MigrationsException e) {
            List<String> warnings = Collections.singletonList(e.getMessage());
            if (e.getCause() instanceof IndexOutOfBoundsException) {
                return new ValidationResult(targetDatabase, ValidationResult.Outcome.INCOMPLETE_MIGRATIONS, warnings);
            }
            return new ValidationResult(targetDatabase, ValidationResult.Outcome.DIFFERENT_CONTENT, warnings);
        }
    }

    public Catalog getLocalCatalog() {
        if (this.getMigrations().isEmpty()) {
            return Catalog.empty();
        }
        return this.context.getCatalog();
    }

    public Catalog getDatabaseCatalog() {
        return this.executeWithinLock(() -> {
            try (Session session = this.context.getSession();){
                Neo4jVersion neo4jVersion = Neo4jVersion.of(this.context.getConnectionDetails().getServerVersion());
                Catalog catalog = DatabaseCatalog.of(neo4jVersion, (SimpleQueryRunner)session, true);
                return catalog;
            }
        }, null, null);
    }

    public static String getUserAgent() {
        return "neo4j-migrations/" + ProductVersion.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithinLock(Supplier<T> executable, LifecyclePhase before, LifecyclePhase after) {
        this.driver.verifyConnectivity();
        MigrationsLock lock = new MigrationsLock(this.context);
        try {
            T t;
            lock.lock();
            if (this.beforeFirstUseHasBeenCalled.compareAndSet(false, true)) {
                this.invokeCallbacks(LifecyclePhase.BEFORE_FIRST_USE);
            }
            try {
                this.invokeCallbacks(before);
                t = executable.get();
                this.invokeCallbacks(after);
            }
            catch (Throwable throwable) {
                this.invokeCallbacks(after);
                throw throwable;
            }
            return t;
        }
        finally {
            try {
                if (lock.isLocked()) {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not unlock\u2026 Please check for residues (Nodes labeled `__Neo4jMigrationsLock`).");
            }
        }
    }

    private void invokeCallbacks(LifecyclePhase phase) {
        if (phase == null) {
            return;
        }
        DefaultLifecycleEvent event = new DefaultLifecycleEvent(phase, this.context);
        this.getCallbacks().getOrDefault((Object)phase, Collections.emptyList()).forEach(callback -> {
            try {
                callback.on(event);
            }
            catch (Exception e) {
                throw new MigrationsException("Could not invoke " + Migrations.toString(callback, phase) + ".", e);
            }
            LOGGER.log(Level.INFO, Migrations.logMessageSupplier(callback, phase));
        });
    }

    static Supplier<String> logMessageSupplier(Callback callback, LifecyclePhase phase) {
        return () -> String.format("Invoked %s.", Migrations.toString(callback, phase));
    }

    static String toString(Callback callback, LifecyclePhase phase) {
        Optional<String> optionalDescription = callback.getOptionalDescription();
        return optionalDescription.map(d -> String.format("\"%s\" %s", d, phase.readable())).orElseGet(() -> String.format("%s callback", phase.toCamelCase()));
    }

    private Optional<MigrationVersion> getLastAppliedVersion() {
        Optional<MigrationVersion> optional;
        block8: {
            Session session = this.context.getSchemaSession();
            try {
                Node lastMigration = (Node)session.executeRead(tx -> tx.run("MATCH (l:__Neo4jMigration) WHERE coalesce(l.migrationTarget,'<default>') = coalesce($migrationTarget,'<default>') AND NOT (l)-[:MIGRATED_TO]->(:__Neo4jMigration) RETURN l", Collections.singletonMap(PROPERTY_MIGRATION_TARGET, this.config.getMigrationTargetIn(this.context).orElse(null))).single().get(0).asNode());
                String version = lastMigration.get(PROPERTY_MIGRATION_VERSION).asString();
                String description = lastMigration.get(PROPERTY_MIGRATION_DESCRIPTION).asString();
                optional = Optional.of(MigrationVersion.withValueAndDescription(version, description, lastMigration.get("repeatable").asBoolean(false)));
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchRecordException e) {
                    return Optional.empty();
                }
            }
            session.close();
        }
        return optional;
    }

    static void ensureConstraints(MigrationContext context) {
        if (!HBD.is44OrHigher(context.getConnectionDetails())) {
            return;
        }
        ConnectionDetails cd = context.getConnectionDetails();
        try (Session session = context.getSchemaSession();){
            Renderer<Constraint> renderer = Renderer.get(Renderer.Format.CYPHER, Constraint.class);
            RenderConfig createConfig = RenderConfig.create().forVersionAndEdition(cd.getServerVersion(), cd.getServerEdition());
            String stmt = renderer.render(UNIQUE_VERSION, createConfig);
            HBD.silentCreateConstraint(context.getConnectionDetails(), session, stmt, null, () -> "Could not create unique constraint for targeted migrations.");
        }
    }

    boolean checksumOfRepeatableChanged(MigrationChain currentChain, Migration migration) {
        if (!migration.isRepeatable()) {
            return false;
        }
        Optional<String> appliedChecksum = currentChain.getElements().stream().filter(e -> e.getVersion().equals(migration.getVersion().getValue())).findFirst().flatMap(MigrationChain.Element::getChecksum);
        return !ChainBuilder.matches(appliedChecksum, migration);
    }

    private void apply0(List<Migration> migrations) {
        Migrations.ensureConstraints(this.context);
        MigrationVersion previousVersion = this.getLastAppliedVersion().orElseGet(MigrationVersion::baseline);
        MigrationChain chain = this.chainBuilder.buildChain(this.context, migrations);
        StopWatch stopWatch = new StopWatch();
        for (Migration migration : migrations) {
            boolean repeated = false;
            Supplier<String> logMessage = () -> String.format("Applied migration %s.", Migrations.toString(migration));
            if (previousVersion != MigrationVersion.baseline() && chain.isApplied(migration.getVersion().getValue())) {
                if (this.checksumOfRepeatableChanged(chain, migration)) {
                    logMessage = () -> String.format("Reapplied changed repeatable migration %s", Migrations.toString(migration));
                    repeated = true;
                } else {
                    LOGGER.log(Level.INFO, "Skipping already applied migration {0}", Migrations.toString(migration));
                    continue;
                }
            }
            try {
                stopWatch.start();
                migration.apply(this.context);
                long executionTime = stopWatch.stop();
                previousVersion = this.recordApplication(chain.getUsername(), previousVersion, migration, executionTime, repeated);
                LOGGER.log(Level.INFO, logMessage);
            }
            catch (Exception e) {
                if (HBD.constraintProbablyRequiredEnterpriseEdition(e, this.getConnectionDetails())) {
                    throw new MigrationsException(Messages.INSTANCE.format("errors.edition_mismatch", Migrations.toString(migration), this.getConnectionDetails().getServerEdition()));
                }
                if (e instanceof MigrationsException) {
                    throw e;
                }
                throw new MigrationsException("Could not apply migration: " + Migrations.toString(migration) + ".", e);
            }
            finally {
                stopWatch.reset();
            }
        }
    }

    private MigrationVersion recordApplication(String neo4jUser, MigrationVersion previousVersion, Migration appliedMigration, long executionTime, boolean repeated) {
        Optional<String> migrationTarget = this.context.getConfig().getMigrationTargetIn(this.context);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("neo4jUser", neo4jUser);
        parameters.put("previousVersion", previousVersion.getValue());
        parameters.put("appliedMigration", Migrations.toProperties(appliedMigration));
        parameters.put("installedBy", this.config.getOptionalInstalledBy().map(Values::value).orElse(Values.NULL));
        parameters.put("executionTime", executionTime);
        parameters.put(PROPERTY_MIGRATION_TARGET, migrationTarget.orElse(null));
        TransactionCallback uow = repeated ? t -> t.run("MATCH (l:__Neo4jMigration) WHERE l.version = $appliedMigration['version'] AND coalesce(l.migrationTarget,'<default>') = coalesce($migrationTarget,'<default>') WITH l CREATE (l) - [:REPEATED {checksum: $appliedMigration['checksum'], at: datetime({timezone: 'UTC'}), in: duration( {milliseconds: $executionTime} ), by: $installedBy, connectedAs: $neo4jUser}] -> (l)", parameters).consume() : t -> {
            String mergeOrMatchAndMaybeCreate;
            if (migrationTarget.isPresent()) {
                mergeOrMatchAndMaybeCreate = "MERGE (p:__Neo4jMigration {version: $previousVersion, migrationTarget: $migrationTarget}) ";
            } else {
                Result result = t.run("MATCH (p:__Neo4jMigration {version: $previousVersion}) WHERE p.migrationTarget IS NULL RETURN id(p) AS id", Values.parameters((Object[])new Object[]{"previousVersion", previousVersion.getValue()}));
                if (result.hasNext()) {
                    parameters.put("id", result.single().get("id").asLong());
                    mergeOrMatchAndMaybeCreate = "MATCH (p) WHERE id(p) = $id WITH p ";
                } else {
                    mergeOrMatchAndMaybeCreate = "CREATE (p:__Neo4jMigration {version: $previousVersion}) ";
                }
            }
            return t.run(mergeOrMatchAndMaybeCreate + "CREATE (c:__Neo4jMigration) SET c = $appliedMigration, c.migrationTarget = $migrationTarget MERGE (p) - [:MIGRATED_TO {at: datetime({timezone: 'UTC'}), in: duration( {milliseconds: $executionTime} ), by: $installedBy, connectedAs: $neo4jUser}] -> (c)", parameters).consume();
        };
        try (Session session = this.context.getSchemaSession();){
            session.executeWrite(uow);
        }
        return appliedMigration.getVersion();
    }

    private static Map<String, Object> toProperties(Migration migration) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(PROPERTY_MIGRATION_VERSION, migration.getVersion().getValue());
        migration.getOptionalDescription().ifPresent(v -> properties.put(PROPERTY_MIGRATION_DESCRIPTION, v));
        properties.put("type", Migrations.getMigrationType(migration).name());
        properties.put("repeatable", migration.isRepeatable());
        properties.put("source", migration.getSource());
        migration.getChecksum().ifPresent(v -> properties.put("checksum", v));
        return Collections.unmodifiableMap(properties);
    }

    static MigrationType getMigrationType(Migration migration) {
        MigrationType type;
        if (migration instanceof JavaBasedMigration) {
            type = MigrationType.JAVA;
        } else if (migration instanceof AbstractCypherBasedMigration) {
            type = MigrationType.CYPHER;
        } else if (migration instanceof CatalogBasedMigration) {
            type = MigrationType.CATALOG;
        } else {
            throw new MigrationsException("Unknown migration type: " + migration.getClass());
        }
        return type;
    }

    static String toString(Migration migration) {
        return migration.getVersion().getValue() + migration.getOptionalDescription().map(d -> String.format(" (\"%s\")", d)).orElse("");
    }

    static class DeletedChainsWithCounters {
        final List<String> chainsDeleted;
        final SummaryCounters counter;
        final long additionalConstraintsRemoved;

        DeletedChainsWithCounters(List<String> chainsDeleted, SummaryCounters counter) {
            this.chainsDeleted = chainsDeleted;
            this.counter = counter;
            this.additionalConstraintsRemoved = 0L;
        }

        DeletedChainsWithCounters(DeletedChainsWithCounters source, long additionalConstraintsRemoved) {
            this.chainsDeleted = source.chainsDeleted;
            this.counter = source.counter;
            this.additionalConstraintsRemoved = additionalConstraintsRemoved;
        }
    }
}

