/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.DatabaseCatalog;
import ac.simons.neo4j.migrations.core.HBD;
import ac.simons.neo4j.migrations.core.Messages;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.driver.Session;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;

final class MigrationsLock {
    private static final Logger LOGGER = Logger.getLogger(MigrationsLock.class.getName());
    private static final String DEFAULT_NAME_OF_LOCK = "John Doe";
    private static final Supplier<String> LOCK_FAILED_MESSAGE_SUPPLIER = () -> Messages.INSTANCE.get("lock_failed");
    private static final Renderer<Constraint> CONSTRAINT_RENDERER = Renderer.get(Renderer.Format.CYPHER, Constraint.class);
    static final Constraint[] REQUIRED_CONSTRAINTS = new Constraint[]{Constraint.forNode("__Neo4jMigrationsLock").named("__Neo4jMigrationsLock__has_unique_id").unique("id"), Constraint.forNode("__Neo4jMigrationsLock").named("__Neo4jMigrationsLock__has_unique_name").unique("name")};
    private final MigrationContext context;
    private final String id = UUID.randomUUID().toString();
    private final String nameOfLock;
    private final ReentrantReadWriteLock lockLockingLocks = new ReentrantReadWriteLock();
    private final Thread cleanUpTask = new Thread(this::unlock0);

    MigrationsLock(MigrationContext context) {
        this.context = context;
        this.nameOfLock = context.getConfig().getOptionalDatabase().map(v -> v.toLowerCase(Locale.ROOT)).filter(v -> !v.equals("neo4j")).orElse(DEFAULT_NAME_OF_LOCK);
    }

    private void createUniqueConstraintIfNecessary() {
        int constraintsAdded = 0;
        ConnectionDetails cd = this.context.getConnectionDetails();
        try (Session session = this.context.getSchemaSession();){
            Renderer<Constraint> renderer = Renderer.get(Renderer.Format.CYPHER, Constraint.class);
            RenderConfig createConfig = RenderConfig.create().forVersionAndEdition(cd.getServerVersion(), cd.getServerEdition());
            for (Constraint constraint : REQUIRED_CONSTRAINTS) {
                String cypher = renderer.render(constraint, createConfig);
                try {
                    constraintsAdded += HBD.silentCreateConstraint(cd, session, cypher, null, LOCK_FAILED_MESSAGE_SUPPLIER).intValue();
                }
                catch (MigrationsException e) {
                    if (MigrationsLock.constraintWithNameAlreadyExistsAndIsEquivalent(cd, session, constraint, e)) continue;
                    throw e;
                }
            }
        }
        LOGGER.log(Level.FINE, "Created {0} constraints", constraintsAdded);
    }

    private static boolean constraintWithNameAlreadyExistsAndIsEquivalent(ConnectionDetails cd, Session session, Constraint constraint, MigrationsException e) {
        Neo4jException ne;
        Throwable throwable = e.getCause();
        return throwable instanceof Neo4jException && "Neo.ClientError.Schema.ConstraintWithNameAlreadyExists".equals((ne = (Neo4jException)throwable).code()) && DatabaseCatalog.full(Neo4jVersion.of(cd.getServerVersion()), (SimpleQueryRunner)session).containsEquivalentItem(constraint);
    }

    SummaryCounters clean() {
        int nodesDeleted = 0;
        int relationshipsDeleted = 0;
        int constraintsRemoved = 0;
        int indexesRemoved = 0;
        ConnectionDetails cd = this.context.getConnectionDetails();
        try (Session session = this.context.getSchemaSession();){
            SummaryCounters summaryCounters = (SummaryCounters)session.executeWrite(tx -> tx.run("MATCH (l:`__Neo4jMigrationsLock`) delete l").consume().counters());
            nodesDeleted += summaryCounters.nodesDeleted();
            relationshipsDeleted += summaryCounters.relationshipsDeleted();
            RenderConfig dropConfig = RenderConfig.drop().forVersionAndEdition(cd.getServerVersion(), cd.getServerEdition());
            for (Constraint constraint : REQUIRED_CONSTRAINTS) {
                String cypher = CONSTRAINT_RENDERER.render(constraint, dropConfig);
                Integer singleConstraint = HBD.silentDropConstraint(cd, session, cypher, null);
                if (singleConstraint == 0) {
                    cypher = CONSTRAINT_RENDERER.render(constraint, dropConfig.ignoreName());
                    singleConstraint = HBD.silentDropConstraint(cd, session, cypher, null);
                }
                constraintsRemoved += singleConstraint.intValue();
            }
        }
        return new SummaryCountersImpl(0, nodesDeleted, 0, relationshipsDeleted, 0, 0, 0, 0, indexesRemoved, 0, constraintsRemoved, 0);
    }

    String lock() {
        if (LOGGER.isLoggable(Level.FINE)) {
            MigrationsConfig config = this.context.getConfig();
            UnaryOperator databaseNameMapper = v -> "database `" + v + "`";
            String formattedTargetDatabaseName = config.getOptionalDatabase().map(databaseNameMapper).orElse("the default database");
            LOGGER.log(Level.FINE, "Acquiring lock {0} on {1} in {2}", new Object[]{this.id, formattedTargetDatabaseName, config.getOptionalSchemaDatabase().map(databaseNameMapper).orElse(formattedTargetDatabaseName)});
        }
        this.createUniqueConstraintIfNecessary();
        try {
            String string;
            block12: {
                Session session = this.context.getSchemaSession();
                try {
                    this.lockLockingLocks.writeLock().lock();
                    String internalId = (String)session.executeWrite(t -> t.run("CREATE (l:__Neo4jMigrationsLock {id: $id, name: $name}) RETURN l", Values.parameters((Object[])new Object[]{"id", this.id, "name", this.nameOfLock})).single().get("l").asNode().elementId());
                    LOGGER.log(Level.FINE, "Acquired lock {0} with internal id {1}", new Object[]{this.id, internalId});
                    Runtime.getRuntime().addShutdownHook(this.cleanUpTask);
                    string = this.id;
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Neo4jException e) {
                        throw new MigrationsException("Cannot create __Neo4jMigrationsLock node. Likely another migration is going on or has crashed", e);
                    }
                }
                session.close();
            }
            return string;
        }
        finally {
            this.lockLockingLocks.writeLock().unlock();
        }
    }

    boolean isLocked() {
        try {
            boolean bl;
            block9: {
                Session session = this.context.getSchemaSession();
                try {
                    this.lockLockingLocks.readLock().lock();
                    bl = (Boolean)session.executeRead(tx -> tx.run("MATCH (l:__Neo4jMigrationsLock {id: $id, name: $name}) RETURN count(l)", Values.parameters((Object[])new Object[]{"id", this.id, "name", this.nameOfLock})).single().get(0).asLong() > 0L);
                    if (session == null) break block9;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return bl;
        }
        finally {
            this.lockLockingLocks.readLock().unlock();
        }
    }

    void unlock() {
        try {
            this.unlock0();
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(this.cleanUpTask);
        }
    }

    private void unlock0() {
        try (Session session = this.context.getSchemaSession();){
            ResultSummary resultSummary = (ResultSummary)session.executeWrite(t -> t.run("MATCH (l:__Neo4jMigrationsLock {id: $id}) DELETE l", Values.parameters((Object[])new Object[]{"id", this.id})).consume());
            LOGGER.log(Level.FINE, "Released lock {0} ({1} node(s) deleted)", new Object[]{this.id, resultSummary.counters().nodesDeleted()});
        }
    }

    record SummaryCountersImpl(int nodesCreated, int nodesDeleted, int relationshipsCreated, int relationshipsDeleted, int propertiesSet, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved, int systemUpdates) implements SummaryCounters
    {
        public boolean containsUpdates() {
            return (this.nodesCreated | this.nodesDeleted | this.relationshipsCreated | this.relationshipsDeleted | this.propertiesSet | this.labelsAdded | this.labelsRemoved | this.indexesAdded | this.indexesRemoved | this.constraintsAdded | this.constraintsRemoved) > 0;
        }

        public boolean containsSystemUpdates() {
            return this.systemUpdates > 0;
        }
    }
}

