/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import java.util.Locale;

public enum Neo4jEdition {
    ENTERPRISE,
    COMMUNITY,
    UNDEFINED;


    public static Neo4jEdition of(String edition) {
        return Neo4jEdition.of(edition, true);
    }

    public static Neo4jEdition of(String edition, boolean lenient) {
        if (edition == null) {
            if (!lenient) {
                throw new IllegalArgumentException("Cannot derive an edition from literal null");
            }
            return UNDEFINED;
        }
        String value = edition.trim().toUpperCase(Locale.ROOT);
        if (!lenient) {
            return Neo4jEdition.valueOf(value);
        }
        return switch (value) {
            case "ENTERPRISE" -> ENTERPRISE;
            case "COMMUNITY" -> COMMUNITY;
            default -> UNDEFINED;
        };
    }
}

