/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.internal.SchemaNames;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public enum Neo4jVersion {
    UNDEFINED,
    V3_5(true, "CALL db.constraints()", "CALL db.indexes()"),
    V4_0(true, "CALL db.constraints()", "CALL db.indexes()"),
    V4_1(true, "CALL db.constraints()", "CALL db.indexes()"),
    V4_2(true, "SHOW CONSTRAINTS", "CALL db.indexes()"),
    V4_3(true, "SHOW CONSTRAINTS YIELD *", "SHOW INDEXES YIELD *"),
    V4_4,
    V5,
    LATEST;

    private static final String OLD_SHOW_CONSTRAINTS = "CALL db.constraints()";
    private static final String NEW_SHOW_CONSTRAINTS = "SHOW CONSTRAINTS YIELD *";
    private static final String OLD_SHOW_INDEXES = "CALL db.indexes()";
    private static final String NEW_SHOW_INDEXES = "SHOW INDEXES YIELD *";
    private static final Set<Neo4jVersion> WITH_IDEM_POTENCY;
    private static final Set<Neo4jVersion> WITH_TEXT_INDEXES;
    private static final Set<Neo4jVersion> SERIES_3;
    private static final Set<Neo4jVersion> SERIES_4;
    private static final Set<Neo4jVersion> SERIES_5;
    private final boolean priorTo44;
    private final String showConstraints;
    private final String showIndexes;

    public static Neo4jVersion of(String version) {
        String value;
        String string = value = version == null ? null : version.replaceFirst("(?i)Neo4j[/:]", "");
        if (value == null) {
            return UNDEFINED;
        }
        if (value.startsWith("3.5")) {
            return V3_5;
        }
        if (value.startsWith("4.0")) {
            return V4_0;
        }
        if (value.startsWith("4.1")) {
            return V4_1;
        }
        if (value.startsWith("4.2")) {
            return V4_2;
        }
        if (value.startsWith("4.3")) {
            return V4_3;
        }
        if (value.startsWith("4.4")) {
            return V4_4;
        }
        if (value.startsWith("5.")) {
            return V5;
        }
        return LATEST;
    }

    private Neo4jVersion() {
        this(false, NEW_SHOW_CONSTRAINTS, NEW_SHOW_INDEXES);
    }

    private Neo4jVersion(boolean priorTo44, String showConstraints, String showIndexes) {
        this.priorTo44 = priorTo44;
        this.showConstraints = showConstraints;
        this.showIndexes = showIndexes;
    }

    public String toString() {
        return this.name().replace("V", "").replace("_", ".");
    }

    public boolean isPriorTo44() {
        return this.priorTo44;
    }

    public boolean hasIdempotentOperations() {
        return WITH_IDEM_POTENCY.contains((Object)this);
    }

    public boolean hasTextIndexes() {
        return WITH_TEXT_INDEXES.contains((Object)this);
    }

    public boolean supportsSchemaOptions() {
        return this.compareTo(V4_1) > 0;
    }

    public String getShowConstraints() {
        return this.showConstraints;
    }

    public String getShowIndexes() {
        return this.showIndexes;
    }

    public int getMajorVersion() {
        if (SERIES_3.contains((Object)this)) {
            return 3;
        }
        if (SERIES_4.contains((Object)this)) {
            return 4;
        }
        if (SERIES_5.contains((Object)this)) {
            return 5;
        }
        throw new IllegalStateException("Unknown major version");
    }

    public int getMinorVersion() {
        if (this == LATEST || this == UNDEFINED) {
            return -1;
        }
        String[] parts = this.name().split("_");
        if (parts.length != 2) {
            return -1;
        }
        return Integer.parseInt(parts[1]);
    }

    public String sanitizeSchemaName(String potentiallyNonIdentifier) {
        int major;
        if (potentiallyNonIdentifier == null || potentiallyNonIdentifier.length() == 0) {
            return potentiallyNonIdentifier;
        }
        try {
            major = this.getMajorVersion();
        }
        catch (IllegalStateException e) {
            major = -1;
        }
        int minor = this.getMinorVersion();
        return SchemaNames.sanitize(potentiallyNonIdentifier, false, major, minor).orElseThrow(NoSuchElementException::new);
    }

    static {
        WITH_IDEM_POTENCY = EnumSet.complementOf(EnumSet.of(V3_5, V4_0));
        WITH_TEXT_INDEXES = EnumSet.complementOf(EnumSet.of(V3_5, new Neo4jVersion[]{V4_0, V4_1, V4_2, V4_3, UNDEFINED}));
        SERIES_3 = EnumSet.of(V3_5);
        SERIES_4 = Arrays.stream(Neo4jVersion.values()).filter(v -> v.name().startsWith("V4_")).collect(Collectors.collectingAndThen(Collectors.toSet(), EnumSet::copyOf));
        SERIES_5 = Arrays.stream(Neo4jVersion.values()).filter(v -> v.name().startsWith("V5")).collect(Collectors.collectingAndThen(Collectors.toSet(), EnumSet::copyOf));
    }
}

