/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractPrecondition;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.Precondition;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.driver.Session;

final class QueryPrecondition
extends AbstractPrecondition
implements Precondition {
    private static final Pattern CONDITION_PATTERN = Pattern.compile("(?i)^.*?(?<database> in (target|schema))? (?<!that )q'(?<query>.++)?$");
    private final Database database;
    private final String query;

    static Optional<Function<Precondition.Type, Precondition>> tryToParse(String hint) {
        Matcher matcher = CONDITION_PATTERN.matcher(hint);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String query = matcher.group("query");
        if (query == null || query.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Wrong Cypher precondition %s. Usage: `<assume|assert> [in <target|schema>] q' <cypher statement>`.", Precondition.formattedHint(hint)));
        }
        Database database = matcher.group("database") != null ? Database.valueOf(matcher.group(2).toUpperCase(Locale.ROOT)) : Database.TARGET;
        return Optional.of(type -> new QueryPrecondition((Precondition.Type)((Object)type), query.trim(), database));
    }

    private QueryPrecondition(Precondition.Type type, String query, Database database) {
        super(type);
        this.query = query;
        this.database = database;
    }

    @Override
    public boolean isMet(MigrationContext migrationContext) {
        try (Session session = this.database == Database.SCHEMA ? migrationContext.getSchemaSession() : migrationContext.getSession();){
            boolean bl = (Boolean)session.executeRead(tx -> tx.run(this.query).single().get(0).asBoolean());
            return bl;
        }
    }

    String getQuery() {
        return this.query;
    }

    Database getDatabase() {
        return this.database;
    }

    public String toString() {
        return String.format("// %s in %s q'%s", new Object[]{this.getType().keyword(), this.getDatabase(), this.query});
    }

    static enum Database {
        TARGET,
        SCHEMA;

    }
}

