/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Defaults;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public final class ResourceContext {
    private final URL url;
    private final MigrationsConfig config;

    public static ResourceContext of(URL url, MigrationsConfig config) {
        return new ResourceContext(url, config);
    }

    private ResourceContext(URL url, MigrationsConfig config) {
        this.url = url;
        this.config = config;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getIdentifier() {
        return ResourceContext.generateIdentifierOf(this.url);
    }

    static String generateIdentifierOf(URL url) {
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, Defaults.CYPHER_SCRIPT_ENCODING.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MigrationsException("Somethings broken: UTF-8 encoding not supported.");
        }
        int lastIndexOf = path.lastIndexOf("/");
        return lastIndexOf < 0 ? path : path.substring(lastIndexOf + 1);
    }

    public MigrationsConfig getConfig() {
        return this.config;
    }
}

