/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.DatabaseOperationResult;
import ac.simons.neo4j.migrations.core.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class ValidationResult
implements DatabaseOperationResult {
    private static final Set<Outcome> NEEDS_REPAIR = EnumSet.of(Outcome.INCOMPLETE_MIGRATIONS, Outcome.DIFFERENT_CONTENT, Outcome.UNDEFINED);
    private final String affectedDatabase;
    private final Outcome outcome;
    private final List<String> warnings;

    ValidationResult(Optional<String> affectedDatabase, Outcome outcome, List<String> warnings) {
        this.affectedDatabase = affectedDatabase.orElse(null);
        this.outcome = outcome;
        this.warnings = new ArrayList<String>(warnings);
    }

    @Override
    public Collection<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    @Override
    public String prettyPrint() {
        String key = "validation-result.outcome." + this.outcome.name().toLowerCase(Locale.ROOT);
        return MessageFormat.format(Messages.INSTANCE.get(key), this.getAffectedDatabase().map(v -> "`" + v + "`").orElse("the default database"));
    }

    @Override
    public Optional<String> getAffectedDatabase() {
        return Optional.ofNullable(this.affectedDatabase);
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public boolean isValid() {
        return this.outcome == Outcome.VALID;
    }

    public boolean needsRepair() {
        return NEEDS_REPAIR.contains((Object)this.outcome);
    }

    public static enum Outcome {
        UNDEFINED,
        VALID,
        INCOMPLETE_DATABASE,
        INCOMPLETE_MIGRATIONS,
        DIFFERENT_CONTENT;

    }
}

