/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractPrecondition;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.Precondition;
import ac.simons.neo4j.migrations.core.internal.Neo4jVersionComparator;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class VersionPrecondition
extends AbstractPrecondition
implements Precondition {
    private static final String MMP_PATTERN = "\\d++(\\.\\d++)*+";
    private static final Pattern CONDITION_PATTERN = Pattern.compile("(?i)^ *+// *+(?:assume|assert) that version is *+(?<versions>\\d++(\\.\\d++)*+[\\w\\s.,]*+)?.*+$");
    private static final Pattern CONDITION_RANGE_PATTERN = Pattern.compile("(?i)^ *+// *+(?:assume|assert) that version is (lt|ge) (?<versions>\\d++(\\.\\d++)*+).*+$");
    private static final Pattern VERSION_SUB_PATTERN = Pattern.compile("\\d++(\\.\\d++)*+");
    private final Mode mode;
    private final Set<String> versions;

    static Optional<Function<Precondition.Type, Precondition>> tryToParse(String hint) {
        Mode mode;
        Matcher matcher = CONDITION_RANGE_PATTERN.matcher(hint);
        if (matcher.matches()) {
            mode = Mode.valueOf(matcher.group(1).toUpperCase(Locale.ROOT));
        } else {
            matcher = CONDITION_PATTERN.matcher(hint);
            if (!matcher.find()) {
                return Optional.empty();
            }
            mode = Mode.EXACT;
        }
        try {
            String rawVersions = matcher.group("versions");
            rawVersions = rawVersions.replace("or", ",");
            TreeSet<CallSite> formattedVersions = new TreeSet<CallSite>();
            for (String rawVersion : rawVersions.split(",")) {
                String version = rawVersion.trim();
                if (!VERSION_SUB_PATTERN.matcher(version).matches()) {
                    throw new IllegalArgumentException();
                }
                formattedVersions.add((CallSite)((Object)("Neo4j/" + version)));
            }
            return Optional.of(type -> new VersionPrecondition((Precondition.Type)((Object)type), mode, (Set<String>)formattedVersions));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException(String.format("Wrong version precondition %s. Usage: `<assume|assert> that version is <versions>`. With <versions> being a comma separated list of major.minor.patch versions.", Precondition.formattedHint(hint)));
        }
    }

    private VersionPrecondition(Precondition.Type type, Mode mode, Set<String> versions) {
        super(type);
        this.mode = mode;
        this.versions = versions;
    }

    @Override
    public boolean isMet(MigrationContext migrationContext) {
        String serverVersion = migrationContext.getConnectionDetails().getServerVersion();
        if (this.mode == Mode.EXACT) {
            return this.versions.stream().anyMatch(serverVersion::startsWith);
        }
        return this.versions.stream().findFirst().map(version -> {
            int result = new Neo4jVersionComparator().compare(serverVersion, (String)version);
            return this.mode == Mode.LT == result < 0;
        }).orElse(false);
    }

    Collection<String> getVersions() {
        return Collections.unmodifiableCollection(this.versions);
    }

    public String toString() {
        return String.format("// %s that version is %s%s", this.getType().keyword(), this.mode == Mode.EXACT ? "" : this.mode.name().toLowerCase(Locale.ROOT) + " ", this.versions.stream().map(s -> s.replace("Neo4j/", "")).collect(Collectors.joining(", ")).trim());
    }

    static enum Mode {
        LT,
        GE,
        EXACT;

    }
}

