/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.CatalogImpl;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.EmptyCatalog;
import ac.simons.neo4j.migrations.core.catalog.Index;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@FunctionalInterface
public interface Catalog {
    public static Catalog of(Document document) {
        NodeList catalog = document.getElementsByTagName("catalog");
        if (catalog.getLength() > 1) {
            throw new IllegalArgumentException("More than one catalog item found.");
        }
        ArrayList items = new ArrayList();
        if (catalog.getLength() == 0) {
            return Catalog.empty();
        }
        NodeList constraintNodeList = ((Element)catalog.item(0)).getElementsByTagName("constraint");
        for (int i = 0; i < constraintNodeList.getLength(); ++i) {
            Element item = (Element)constraintNodeList.item(i);
            items.add(Constraint.parse(item));
        }
        NodeList indexNodeList = ((Element)catalog.item(0)).getElementsByTagName("index");
        for (int i = 0; i < indexNodeList.getLength(); ++i) {
            Element item = (Element)indexNodeList.item(i);
            items.add(Index.parse(item));
        }
        return new CatalogImpl(items);
    }

    public static Catalog of(Collection<CatalogItem<?>> items) {
        return new CatalogImpl(items);
    }

    public static Catalog empty() {
        return EmptyCatalog.INSTANCE;
    }

    public Collection<CatalogItem<?>> getItems();

    default public boolean containsEquivalentItem(CatalogItem<?> other) {
        return this.getItems().stream().anyMatch(item -> item.isEquivalentTo(other));
    }

    default public boolean isEmpty() {
        return this.getItems().isEmpty();
    }
}

