/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;

enum CatalogToCypherRenderer implements Renderer<Catalog>
{
    INSTANCE;


    @Override
    public void render(Catalog catalog, RenderConfig config, OutputStream target) throws IOException {
        byte[] separator = (";" + System.lineSeparator()).getBytes(StandardCharsets.UTF_8);
        ConcurrentHashMap<Class, Renderer> cachedRenderer = new ConcurrentHashMap<Class, Renderer>(4);
        for (CatalogItem<?> item : catalog.getItems()) {
            Renderer renderer = cachedRenderer.computeIfAbsent(item.getClass(), type -> Renderer.get(Renderer.Format.CYPHER, type));
            renderer.render(item, config, target);
            target.write(separator);
        }
        target.flush();
    }
}

