/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.Neo4jEdition;
import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.AnonymousCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.CypherRenderingUtils;
import ac.simons.neo4j.migrations.core.catalog.FormattableCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Operator;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import ac.simons.neo4j.migrations.core.catalog.TargetEntityType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Formattable;
import java.util.Set;
import java.util.stream.Collectors;

enum ConstraintToCypherRenderer implements Renderer<Constraint>
{
    INSTANCE;

    private static final Set<Neo4jVersion> RANGE_41_TO_43;
    private static final Set<Neo4jVersion> RANGE_41_TO_42;
    private static final String KEYWORD_REQUIRE = "REQUIRE";
    private static final String KEYWORD_ASSERT = "ASSERT";

    @Override
    public void render(Constraint constraint, RenderConfig config, OutputStream target) throws IOException {
        Neo4jVersion version = config.getVersion();
        if (config.isIdempotent() && !version.hasIdempotentOperations() && !config.isIgnoreName()) {
            throw new IllegalArgumentException(String.format("The given constraint cannot be rendered in an idempotent fashion on Neo4j %s.", new Object[]{version}));
        }
        if (constraint.getProperties().size() > 1) {
            if (!EnumSet.of(Constraint.Type.UNIQUE, Constraint.Type.KEY).contains(constraint.getType())) {
                throw new IllegalArgumentException("Only unique and node key constraints support multiple properties.");
            }
            if (config.isVersionPriorTo44() && constraint.getType() != Constraint.Type.KEY) {
                throw new IllegalArgumentException("Constraints require exactly one property prior to Neo4j 4.4.");
            }
        }
        if (!constraint.hasName() && config.isIdempotent() && config.getOperator() == Operator.DROP) {
            throw new IllegalArgumentException("The constraint can only be rendered in the given context when having a name.");
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(target, StandardCharsets.UTF_8));
        if (config.getOperator() == Operator.DROP && config.getVersion() != Neo4jVersion.V3_5 && constraint.hasName() && !config.isIgnoreName()) {
            w.write(String.format("DROP %#s%s", new FormattableCatalogItem(constraint, config.getVersion()), config.ifNotExistsOrEmpty()));
        } else {
            switch ((Constraint.Type)constraint.getType()) {
                case UNIQUE: {
                    w.write(this.renderUniqueConstraint(constraint, config));
                    break;
                }
                case EXISTS: {
                    w.write(this.renderPropertyExists(constraint, config));
                    break;
                }
                case KEY: {
                    w.write(this.renderNodeKey(constraint, config));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type of constraint: " + constraint.getType());
                }
            }
        }
        CypherRenderingUtils.renderOptions(constraint, config, w);
        ((Writer)w).flush();
    }

    private String renderNodeKey(Constraint constraint, RenderConfig config) {
        if (config.getOperator() == Operator.CREATE && config.getEdition() != Neo4jEdition.ENTERPRISE) {
            throw new IllegalStateException(String.format("This constraint cannot be created with %s edition.", new Object[]{config.getEdition()}));
        }
        Neo4jVersion version = config.getVersion();
        Formattable item = this.formattableItem(constraint, config);
        String identifier = version.sanitizeSchemaName(constraint.getIdentifier());
        String properties = ConstraintToCypherRenderer.renderProperties(version, "n", constraint, !version.isPriorTo44());
        Operator operator = config.getOperator();
        if (version == Neo4jVersion.V3_5 || version == Neo4jVersion.V4_0) {
            return String.format("%s %#s ON (n:%s) ASSERT %s IS NODE KEY", new Object[]{operator, item, identifier, properties});
        }
        if (RANGE_41_TO_43.contains((Object)version)) {
            return String.format("%s %#s %sON (n:%s) ASSERT %s IS NODE KEY", new Object[]{operator, item, config.ifNotExistsOrEmpty(), identifier, properties});
        }
        String adjective = operator == Operator.CREATE ? "FOR" : "ON";
        String verb = operator == Operator.CREATE ? KEYWORD_REQUIRE : KEYWORD_ASSERT;
        return String.format("%s %#s %s%s (n:%s) %s %s IS NODE KEY", new Object[]{operator, item, config.ifNotExistsOrEmpty(), adjective, identifier, verb, properties});
    }

    private String renderPropertyExists(Constraint item, RenderConfig config) {
        if (config.getOperator() == Operator.CREATE && config.getEdition() != Neo4jEdition.ENTERPRISE) {
            throw new IllegalStateException(String.format("This constraint cannot be created with %s edition.", new Object[]{config.getEdition()}));
        }
        if (item.getTargetEntityType() == TargetEntityType.NODE) {
            return this.renderNodePropertyExists(item, config);
        }
        return this.renderRelationshipPropertyExists(item, config);
    }

    private String renderRelationshipPropertyExists(Constraint constraint, RenderConfig config) {
        return this.renderPropertyExists(constraint, config, "r", "()-[%s:%s]-()");
    }

    private String renderNodePropertyExists(Constraint constraint, RenderConfig config) {
        return this.renderPropertyExists(constraint, config, "n", "(%s:%s)");
    }

    private String renderPropertyExists(Constraint constraint, RenderConfig config, String variable, String templateFragment) {
        Neo4jVersion version = config.getVersion();
        Formattable item = this.formattableItem(constraint, config);
        String identifier = version.sanitizeSchemaName(constraint.getIdentifier());
        String properties = ConstraintToCypherRenderer.renderProperties(version, variable, constraint);
        Operator operator = config.getOperator();
        String object = String.format(operator == Operator.CREATE ? "%s IS NOT NULL" : "exists(%s)", properties);
        if (version == Neo4jVersion.V3_5 || version == Neo4jVersion.V4_0) {
            String format = "%s %#s ON " + templateFragment + " ASSERT exists(%s)";
            return String.format(format, new Object[]{operator, item, variable, identifier, properties});
        }
        if (RANGE_41_TO_42.contains((Object)version)) {
            String format = "%s %#s %sON " + templateFragment + " ASSERT exists(%s)";
            return String.format(format, new Object[]{operator, item, config.ifNotExistsOrEmpty(), variable, identifier, properties});
        }
        if (version == Neo4jVersion.V4_3) {
            String format = "%s %#s %sON " + templateFragment + " ASSERT %s";
            return String.format(format, new Object[]{operator, item, config.ifNotExistsOrEmpty(), variable, identifier, object});
        }
        String adjective = operator == Operator.CREATE ? "FOR" : "ON";
        String verb = operator == Operator.CREATE ? KEYWORD_REQUIRE : KEYWORD_ASSERT;
        String format = "%s %#s %s%s " + templateFragment + " %s %s";
        return String.format(format, new Object[]{operator, item, config.ifNotExistsOrEmpty(), adjective, variable, identifier, verb, object});
    }

    private String renderUniqueConstraint(Constraint constraint, RenderConfig config) {
        if (constraint.getProperties().size() > 1 && config.getVersion().isPriorTo44()) {
            throw new IllegalArgumentException("Composite unique constraints are not supported prior to Neo4j/4.4.");
        }
        Neo4jVersion version = config.getVersion();
        Formattable item = this.formattableItem(constraint, config);
        String identifier = version.sanitizeSchemaName(constraint.getIdentifier());
        String properties = ConstraintToCypherRenderer.renderProperties(version, "n", constraint);
        Constraint.Type type = (Constraint.Type)constraint.getType();
        Operator operator = config.getOperator();
        if (version == Neo4jVersion.V3_5 || version == Neo4jVersion.V4_0) {
            return String.format("%s %#s ON (n:%s) ASSERT %s IS %s", new Object[]{operator, item, identifier, properties, type});
        }
        if (RANGE_41_TO_43.contains((Object)version)) {
            return String.format("%s %#s %sON (n:%s) ASSERT %s IS %s", new Object[]{operator, item, config.ifNotExistsOrEmpty(), identifier, properties, type});
        }
        String adjective = operator == Operator.CREATE ? "FOR" : "ON";
        String verb = operator == Operator.CREATE ? KEYWORD_REQUIRE : KEYWORD_ASSERT;
        return String.format("%s %#s %s%s (n:%s) %s %s IS %s", new Object[]{operator, item, config.ifNotExistsOrEmpty(), adjective, identifier, verb, properties, type});
    }

    private static String renderProperties(Neo4jVersion version, String prefix, Constraint item) {
        return ConstraintToCypherRenderer.renderProperties(version, prefix, item, true);
    }

    private static String renderProperties(Neo4jVersion version, String prefix, Constraint item, boolean optimizeSingle) {
        if (item.getProperties().size() == 1 && optimizeSingle) {
            return prefix + "." + version.sanitizeSchemaName((String)item.getProperties().iterator().next());
        }
        return item.getProperties().stream().map(version::sanitizeSchemaName).map(v -> prefix + "." + v).collect(Collectors.joining(", ", "(", ")"));
    }

    Formattable formattableItem(Constraint item, RenderConfig config) {
        return config.isIgnoreName() || config.getVersion() == Neo4jVersion.V3_5 ? new AnonymousCatalogItem(item) : new FormattableCatalogItem(item, config.getVersion());
    }

    static {
        RANGE_41_TO_43 = EnumSet.of(Neo4jVersion.V4_1, Neo4jVersion.V4_2, Neo4jVersion.V4_3);
        RANGE_41_TO_42 = EnumSet.of(Neo4jVersion.V4_1, Neo4jVersion.V4_2);
    }
}

