/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.AbstractCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Operator;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.regex.Pattern;

final class CypherRenderingUtils {
    private static final Pattern MAP_PATTERN = Pattern.compile("(?s)\\{.+}");

    static void renderOptions(AbstractCatalogItem<?> item, RenderConfig config, Writer writer) throws IOException {
        Optional<String> options = item.getOptionalOptions().map(String::trim);
        Neo4jVersion version = config.getVersion();
        if (config.getOperator() == Operator.CREATE && version.supportsSchemaOptions() && options.isPresent() && config.includeOptions()) {
            boolean hasBraces = MAP_PATTERN.matcher(options.get()).matches();
            if (hasBraces) {
                writer.write(" OPTIONS " + options.get());
            } else {
                writer.write(" OPTIONS {" + options.get() + "}");
            }
        }
    }

    private CypherRenderingUtils() {
    }
}

