/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.CustomizableRefactoring;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

abstract class AbstractCustomizableRefactoring {
    protected final String customQuery;
    protected final Integer batchSize;

    protected AbstractCustomizableRefactoring(String customQuery, Integer batchSize) {
        this.customQuery = customQuery;
        this.batchSize = batchSize;
    }

    protected final String filterCustomQuery(String newCustomQuery) {
        return Optional.ofNullable(newCustomQuery).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
    }

    protected final <T extends CustomizableRefactoring<?>> T inBatchesOf0(Integer newBatchSize, Class<T> type, Function<Integer, ? extends T> newInstanceSupplier) {
        if (newBatchSize != null && newBatchSize < 1) {
            throw new IllegalArgumentException("Batch size must be either null or equal or greater one");
        }
        return (T)(Objects.equals(this.batchSize, newBatchSize) ? (CustomizableRefactoring)type.cast(this) : (CustomizableRefactoring)newInstanceSupplier.apply(newBatchSize));
    }

    protected final <T extends CustomizableRefactoring<?>> T withCustomQuery0(String newCustomQuery, Class<T> type, Function<String, ? extends T> newInstanceSupplier) {
        String value = this.filterCustomQuery(newCustomQuery);
        return (T)(Objects.equals(this.customQuery, value) ? (CustomizableRefactoring)type.cast(this) : (CustomizableRefactoring)newInstanceSupplier.apply(newCustomQuery));
    }
}

