/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.CustomizableRefactoring;
import ac.simons.neo4j.migrations.core.refactorings.DefaultAddSurrogateKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AddSurrogateKey
extends CustomizableRefactoring<AddSurrogateKey> {
    public static final String DEFAULT_PROPERTY_NAME = "id";
    public static final String DEFAULT_KEY_GENERATOR = "randomUUID";

    public static AddSurrogateKey toNodes(String primaryLabel, String ... additionalLabels) {
        if (primaryLabel == null) {
            throw new IllegalArgumentException("At least one label is required");
        }
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        labels.add(primaryLabel);
        Collections.addAll(labels, additionalLabels);
        if (labels.stream().anyMatch(String::isBlank)) {
            throw new IllegalArgumentException("Empty identifiers cannot be used to identify target nodes");
        }
        return new DefaultAddSurrogateKey(DefaultAddSurrogateKey.Target.NODE, labels, DEFAULT_PROPERTY_NAME, DEFAULT_KEY_GENERATOR);
    }

    public static AddSurrogateKey toRelationships(String type) {
        if (type == null || type.isBlank()) {
            throw new IllegalArgumentException("An empty type cannot be used to identify target relationships");
        }
        return new DefaultAddSurrogateKey(DefaultAddSurrogateKey.Target.RELATIONSHIP, Set.of(type), DEFAULT_PROPERTY_NAME, DEFAULT_KEY_GENERATOR);
    }

    public static AddSurrogateKey toNodesMatching(String customQuery) {
        if (customQuery == null || customQuery.isBlank()) {
            throw new IllegalArgumentException("The custom query cannot be null or blank");
        }
        return new DefaultAddSurrogateKey(DefaultAddSurrogateKey.Target.NODE, customQuery, DEFAULT_PROPERTY_NAME, DEFAULT_KEY_GENERATOR);
    }

    public static AddSurrogateKey toRelationshipsMatching(String customQuery) {
        if (customQuery == null || customQuery.isBlank()) {
            throw new IllegalArgumentException("The custom query cannot be null or blank");
        }
        return new DefaultAddSurrogateKey(DefaultAddSurrogateKey.Target.RELATIONSHIP, customQuery, DEFAULT_PROPERTY_NAME, DEFAULT_KEY_GENERATOR);
    }

    public AddSurrogateKey withProperty(String var1);

    public AddSurrogateKey withGeneratorFunction(String var1);
}

