/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.DefaultCounters;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Counters {
    public static Counters empty() {
        return Empty.INSTANCE;
    }

    public static Counters of(Map<String, Integer> values) {
        return new DefaultCounters(values.getOrDefault("nodesCreated", 0), values.getOrDefault("nodesDeleted", 0), values.getOrDefault("labelsAdded", 0), values.getOrDefault("labelsRemoved", 0), values.getOrDefault("typesAdded", 0), values.getOrDefault("typesRemoved", 0), values.getOrDefault("propertiesSet", 0), values.getOrDefault("indexesAdded", 0), values.getOrDefault("indexesRemoved", 0), values.getOrDefault("constraintsAdded", 0), values.getOrDefault("constraintsRemoved", 0));
    }

    public int nodesCreated();

    public int nodesDeleted();

    public int labelsAdded();

    public int labelsRemoved();

    public int typesAdded();

    public int typesRemoved();

    public int propertiesSet();

    public int indexesAdded();

    public int indexesRemoved();

    public int constraintsAdded();

    public int constraintsRemoved();

    public Counters add(Counters var1);

    public static enum Empty implements Counters
    {
        INSTANCE;


        @Override
        public int nodesCreated() {
            return 0;
        }

        @Override
        public int nodesDeleted() {
            return 0;
        }

        @Override
        public int labelsAdded() {
            return 0;
        }

        @Override
        public int labelsRemoved() {
            return 0;
        }

        @Override
        public int typesAdded() {
            return 0;
        }

        @Override
        public int typesRemoved() {
            return 0;
        }

        @Override
        public int propertiesSet() {
            return 0;
        }

        @Override
        public int indexesAdded() {
            return 0;
        }

        @Override
        public int indexesRemoved() {
            return 0;
        }

        @Override
        public int constraintsAdded() {
            return 0;
        }

        @Override
        public int constraintsRemoved() {
            return 0;
        }

        @Override
        public Counters add(Counters rhs) {
            if (rhs == INSTANCE) {
                return this;
            }
            return new DefaultCounters(rhs.nodesCreated(), rhs.nodesDeleted(), rhs.labelsAdded(), rhs.labelsRemoved(), rhs.typesAdded(), rhs.typesRemoved(), rhs.propertiesSet(), rhs.indexesAdded(), rhs.indexesRemoved(), rhs.constraintsAdded(), rhs.constraintsRemoved());
        }
    }
}

