/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.DefaultCounters;
import ac.simons.neo4j.migrations.core.refactorings.MigrateBTreeIndexes;
import ac.simons.neo4j.migrations.core.refactorings.QueryRunner;
import ac.simons.neo4j.migrations.core.refactorings.RefactoringContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;

final class DefaultMigrateBTreeIndexes
implements MigrateBTreeIndexes {
    private static final String OPTION_USE_RANGE_INDEX_PROVIDER = "{`indexProvider`: \"range-1.0\"}";
    private final QueryRunner.FeatureSet featureSet;
    private final boolean dropOldIndexes;
    private final String suffix;
    private final Map<String, Index.Type> typeMapping;
    private final Set<String> excludes;
    private final Set<String> includes;
    private final RenderConfig createConfigConstraint;
    private final RenderConfig createConfigIndex;
    private final RenderConfig dropConfig;

    DefaultMigrateBTreeIndexes() {
        this(false, null, null, null, null);
    }

    DefaultMigrateBTreeIndexes(boolean dropOldIndexes, String suffix, Map<String, Index.Type> typeMapping, Collection<String> excludes, Collection<String> includes) {
        this.dropOldIndexes = dropOldIndexes;
        this.suffix = suffix == null || suffix.trim().isEmpty() ? "_new" : suffix.trim();
        this.typeMapping = typeMapping == null ? Collections.emptyMap() : new HashMap<String, Index.Type>(typeMapping);
        this.excludes = excludes == null ? Set.of() : new HashSet<String>(excludes);
        this.includes = includes == null ? Set.of() : new HashSet<String>(includes);
        this.featureSet = QueryRunner.defaultFeatureSet().withRequiredVersion("4.4");
        this.createConfigConstraint = RenderConfig.create().idempotent(true).forVersionAndEdition(this.featureSet.requiredVersion(), "ENTERPRISE").withAdditionalOptions(Collections.singletonList(new RenderConfig.CypherRenderingOptions(){

            @Override
            public boolean includingOptions() {
                return true;
            }

            @Override
            public boolean useExplicitPropertyIndexType() {
                return true;
            }
        }));
        this.createConfigIndex = this.createConfigConstraint.withAdditionalOptions(Collections.singletonList(new RenderConfig.CypherRenderingOptions(){

            @Override
            public boolean useExplicitPropertyIndexType() {
                return true;
            }
        }));
        this.dropConfig = RenderConfig.drop().ifExists().forVersionAndEdition(this.featureSet.requiredVersion(), "ENTERPRISE");
    }

    Map<Long, Constraint> findBTreeBasedConstraints(QueryRunner queryRunner, Map<Long, Index> owners) {
        Map<Long, Index> indexLookup = owners == null ? this.findBTreeBasedIndexes(queryRunner) : owners;
        return queryRunner.run(new Query("SHOW constraints YIELD * WHERE ownedIndexId IN $owners", Collections.singletonMap("owners", indexLookup.keySet()))).stream().collect(Collectors.toMap(r -> r.get("ownedIndexId").asLong(), Constraint::parse));
    }

    Map<Long, Index> findBTreeBasedIndexes(QueryRunner queryRunner) {
        Result result = queryRunner.run(new Query("SHOW indexes YIELD * WHERE toUpper(type) = 'BTREE' RETURN *"));
        return result.stream().collect(Collectors.toMap(r -> r.get("id").asLong(), Index::parse));
    }

    List<CatalogItem<?>> findBTreeBasedItems(QueryRunner queryRunner) {
        List versions = queryRunner.run(new Query("CALL dbms.components() YIELD versions")).single().get("versions").asList(Value::asString);
        if (versions.stream().anyMatch(v -> v.startsWith("5."))) {
            return List.of();
        }
        Map<Long, Index> indexes = this.findBTreeBasedIndexes(queryRunner);
        Map<Long, Constraint> constraints = this.findBTreeBasedConstraints(queryRunner, indexes);
        ArrayList result = new ArrayList();
        Predicate<CatalogItem> notExcluded = c -> !this.excludes.contains(c.getName().getValue());
        notExcluded = notExcluded.and(c -> this.includes.isEmpty() || this.includes.contains(c.getName().getValue()));
        constraints.values().stream().filter(notExcluded).forEach(result::add);
        indexes.entrySet().stream().filter(e -> !constraints.containsKey(e.getKey())).map(Map.Entry::getValue).filter(notExcluded).forEach(result::add);
        return result;
    }

    CatalogItem<?> migrate(CatalogItem<?> old) {
        if (old == null) {
            throw new IllegalArgumentException("Cannot migrate null items");
        }
        String oldName = old.getName().getValue();
        if (old instanceof Constraint) {
            Constraint constraint = (Constraint)old;
            return constraint.withOptions(OPTION_USE_RANGE_INDEX_PROVIDER).withName((String)(this.dropOldIndexes ? oldName : oldName + this.suffix));
        }
        if (old instanceof Index) {
            Index index = (Index)old;
            return index.withOptions(OPTION_USE_RANGE_INDEX_PROVIDER).withName((String)(this.dropOldIndexes ? oldName : oldName + this.suffix)).withType(this.typeMapping.getOrDefault(oldName, Index.Type.PROPERTY));
        }
        throw new IllegalArgumentException("Cannot migrate catalog items of type " + old.getClass());
    }

    @Override
    public Counters apply(RefactoringContext context) {
        Function rendererProvider = new Function<CatalogItem<?>, Renderer<CatalogItem<?>>>(){
            final Map<Class<CatalogItem<?>>, Renderer<CatalogItem<?>>> cachedRenderer = new ConcurrentHashMap(4);

            @Override
            public Renderer<CatalogItem<?>> apply(CatalogItem<?> item) {
                return this.cachedRenderer.computeIfAbsent(item.getClass(), type -> Renderer.get(Renderer.Format.CYPHER, type));
            }
        };
        Counters counters = Counters.empty();
        try (QueryRunner tx = context.getQueryRunner(this.featureSet);){
            List<CatalogItem<?>> bTreeBasedItems = this.findBTreeBasedItems(tx);
            StringJoiner dropStatements = new StringJoiner(System.lineSeparator(), System.lineSeparator(), "");
            for (CatalogItem<?> item : bTreeBasedItems) {
                Renderer renderer = (Renderer)rendererProvider.apply(item);
                String dropStatement = renderer.render(item, this.dropConfig);
                if (this.dropOldIndexes) {
                    counters = counters.add(new DefaultCounters(tx.run(new Query(dropStatement)).consume().counters()));
                } else {
                    dropStatements.add(dropStatement + ";");
                }
                CatalogItem<?> migratedItem = this.migrate(item);
                RenderConfig config = item instanceof Index ? this.createConfigIndex : this.createConfigConstraint;
                counters = counters.add(new DefaultCounters(tx.run(new Query(renderer.render(migratedItem, config))).consume().counters()));
            }
            if (!this.dropOldIndexes && LOGGER.isLoggable(Level.INFO) && counters.indexesAdded() + counters.constraintsAdded() > 0) {
                LOGGER.log(Level.INFO, "Future indexes have been created. Use the following statements to drop all BTREE based constraints and indexes:{0}", dropStatements);
            }
        }
        return counters;
    }

    @Override
    public MigrateBTreeIndexes withTypeMapping(Map<String, Index.Type> newTypeMapping) {
        if (Objects.equals(this.typeMapping, newTypeMapping) || newTypeMapping == null && this.typeMapping.isEmpty()) {
            return this;
        }
        return new DefaultMigrateBTreeIndexes(this.dropOldIndexes, this.suffix, newTypeMapping, this.excludes, this.includes);
    }

    @Override
    public MigrateBTreeIndexes withExcludes(Collection<String> newExcludes) {
        if (Objects.equals(this.excludes, newExcludes) || (newExcludes == null || newExcludes.isEmpty()) && this.excludes.isEmpty()) {
            return this;
        }
        return new DefaultMigrateBTreeIndexes(this.dropOldIndexes, this.suffix, this.typeMapping, newExcludes, this.includes);
    }

    @Override
    public MigrateBTreeIndexes withIncludes(Collection<String> newIncludes) {
        if (Objects.equals(this.includes, newIncludes) || (newIncludes == null || newIncludes.isEmpty()) && this.includes.isEmpty()) {
            return this;
        }
        return new DefaultMigrateBTreeIndexes(this.dropOldIndexes, this.suffix, this.typeMapping, this.excludes, newIncludes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMigrateBTreeIndexes that = (DefaultMigrateBTreeIndexes)o;
        return this.dropOldIndexes == that.dropOldIndexes && this.suffix.equals(that.suffix) && this.typeMapping.equals(that.typeMapping) && this.excludes.equals(that.excludes) && this.includes.equals(that.includes);
    }

    public int hashCode() {
        return Objects.hash(this.dropOldIndexes, this.suffix, this.typeMapping, this.excludes);
    }
}

