/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.AbstractCustomizableRefactoring;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.DefaultCounters;
import ac.simons.neo4j.migrations.core.refactorings.FormatStringGenerator;
import ac.simons.neo4j.migrations.core.refactorings.QueryRunner;
import ac.simons.neo4j.migrations.core.refactorings.RefactoringContext;
import ac.simons.neo4j.migrations.core.refactorings.Rename;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.neo4j.driver.Query;

final class DefaultRename
extends AbstractCustomizableRefactoring
implements Rename {
    private final Target target;
    private final String oldValue;
    private final String newValue;
    private final QueryRunner.FeatureSet featureSet;

    DefaultRename(Target targetEntityType, String oldValue, String newValue) {
        this(targetEntityType, oldValue, newValue, null, null);
    }

    private DefaultRename(Target target, String oldValue, String newValue, String customQuery, Integer batchSize) {
        super(customQuery, batchSize);
        this.target = target;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.featureSet = this.batchSize != null ? QueryRunner.defaultFeatureSet().withRequiredVersion("4.4").withBatchingSupport(true) : (this.customQuery != null ? QueryRunner.defaultFeatureSet().withRequiredVersion("4.1") : QueryRunner.defaultFeatureSet().withRequiredVersion("3.5"));
    }

    QueryRunner.FeatureSet getFeatures() {
        return this.featureSet;
    }

    @Override
    public Counters apply(RefactoringContext context) {
        try (QueryRunner queryRunner = context.getQueryRunner(this.featureSet);){
            DefaultCounters defaultCounters = new DefaultCounters(queryRunner.run(this.generateQuery(context::sanitizeSchemaName, context::findSingleResultIdentifier)).consume().counters());
            return defaultCounters;
        }
    }

    @Override
    public Rename inBatchesOf(Integer newBatchSize) {
        return this.inBatchesOf0(newBatchSize, Rename.class, v -> new DefaultRename(this.target, this.oldValue, this.newValue, this.customQuery, (Integer)v));
    }

    @Override
    public Rename withCustomQuery(String newCustomQuery) {
        return this.withCustomQuery0(newCustomQuery, Rename.class, v -> new DefaultRename(this.target, this.oldValue, this.newValue, (String)v, this.batchSize));
    }

    Query generateQuery(UnaryOperator<String> sanitizer, Function<String, Optional<String>> elementExtractor) {
        String varName = this.customQuery == null ? "" : elementExtractor.apply(this.customQuery).orElseThrow(IllegalArgumentException::new);
        return new Query(String.format(this.target.generateFormatString(this.customQuery, this.batchSize), sanitizer.apply(this.oldValue), sanitizer.apply(this.newValue), this.batchSize, this.customQuery, varName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRename that = (DefaultRename)o;
        return this.target == that.target && this.oldValue.equals(that.oldValue) && this.newValue.equals(that.newValue) && Objects.equals(this.customQuery, that.customQuery) && Objects.equals(this.batchSize, that.batchSize);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.oldValue, this.newValue, this.customQuery, this.batchSize);
    }

    static enum Target implements FormatStringGenerator
    {
        LABEL("MATCH (s:%1$s)", "CALL { %4$s } WITH %5$s AS s", "REMOVE s:%1$s SET s:%2$s", "CALL { WITH s REMOVE s:%1$s SET s:%2$s } IN TRANSACTIONS OF %3$d ROWS"),
        TYPE("MATCH (a)-[old:%1$s]->(b)", "CALL { %4$s } WITH %5$s AS old, startNode(%5$s) AS a, endNode(%5$s) AS b", "CREATE (a)-[new:%2$s]->(b) SET new+=old DELETE old", "CALL { WITH old, a, b CREATE (a)-[new:%2$s]->(b) SET new+=old DELETE old } IN TRANSACTIONS OF %3$d ROWS"),
        NODE_PROPERTY("MATCH (s) WHERE s.%1$s IS NOT NULL", "CALL { %4$s } WITH %5$s AS s WHERE s.%1$s IS NOT NULL", "SET s.%2$s = s.%1$s REMOVE s.%1$s", "CALL { WITH s SET s.%2$s = s.%1$s REMOVE s.%1$s } IN TRANSACTIONS OF %3$d ROWS"),
        REL_PROPERTY("MATCH (a)-[r]->(b) WHERE r.%1$s IS NOT NULL", "CALL { %4$s } WITH %5$s AS r WHERE r.%1$s IS NOT NULL", "SET r.%2$s = r.%1$s REMOVE r.%1$s", "CALL { WITH r SET r.%2$s = r.%1$s REMOVE r.%1$s } IN TRANSACTIONS OF %3$d ROWS");

        private final FormatStringGenerator.Fragments fragments;

        private Target(String sourceFragment, String sourceFragmentWithCustomQuery, String actionFragment, String actionFragmentWithBatchSize) {
            this.fragments = new FormatStringGenerator.Fragments(sourceFragment, sourceFragmentWithCustomQuery, actionFragment, actionFragmentWithBatchSize);
        }

        @Override
        public FormatStringGenerator.Fragments getFragments() {
            return this.fragments;
        }
    }
}

