/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.DefaultMerge;
import ac.simons.neo4j.migrations.core.refactorings.Refactoring;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Merge
extends Refactoring {
    public static Merge nodes(String sourceQuery) {
        return new DefaultMerge(sourceQuery, Collections.emptyList());
    }

    public static Merge nodes(String sourceQuery, List<PropertyMergePolicy> mergePolicies) {
        return new DefaultMerge(sourceQuery, new ArrayList<PropertyMergePolicy>((Collection)Objects.requireNonNull(mergePolicies)));
    }

    public static class PropertyMergePolicy {
        private final Pattern pattern;
        private final Strategy strategy;

        public static PropertyMergePolicy of(String pattern, Strategy strategy) {
            return new PropertyMergePolicy(Objects.requireNonNull(pattern), Objects.requireNonNull(strategy));
        }

        private PropertyMergePolicy(String pattern, Strategy strategy) {
            this.pattern = Pattern.compile(pattern);
            this.strategy = strategy;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public Pattern pattern() {
            return this.pattern;
        }

        Object apply(List<Object> values) {
            if (values.isEmpty()) {
                return null;
            }
            return switch (this.strategy) {
                default -> throw new IncompatibleClassChangeError();
                case Strategy.KEEP_ALL -> values;
                case Strategy.KEEP_FIRST -> values.get(0);
                case Strategy.KEEP_LAST -> values.get(values.size() - 1);
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyMergePolicy that = (PropertyMergePolicy)o;
            return this.pattern.pattern().equals(that.pattern.pattern()) && this.strategy == that.strategy;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.pattern, this.strategy});
        }

        public static enum Strategy {
            KEEP_ALL,
            KEEP_FIRST,
            KEEP_LAST;

        }
    }
}

