/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import java.util.Objects;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;

public interface QueryRunner
extends AutoCloseable {
    public static FeatureSet defaultFeatureSet() {
        return new FeatureSet(false, false, "4.4");
    }

    public Result run(Query var1);

    @Override
    default public void close() {
    }

    public static final class FeatureSet {
        private final String requiredVersion;
        private final boolean hasBatchingSupport;
        private final boolean hasElementIdSupport;

        private FeatureSet(boolean hasBatchingSupport, boolean hasElementIdSupport, String requiredVersion) {
            this.hasBatchingSupport = hasBatchingSupport;
            this.hasElementIdSupport = hasElementIdSupport;
            this.requiredVersion = requiredVersion;
        }

        public String requiredVersion() {
            return this.requiredVersion;
        }

        public boolean hasBatchingSupport() {
            return this.hasBatchingSupport;
        }

        public boolean hasElementIdSupport() {
            return this.hasElementIdSupport;
        }

        public FeatureSet withBatchingSupport(boolean batchingSupport) {
            return this.hasBatchingSupport == batchingSupport ? this : new FeatureSet(batchingSupport, this.hasElementIdSupport, this.requiredVersion);
        }

        public FeatureSet withElementIdSupport(boolean elementIdSupport) {
            return this.hasElementIdSupport == elementIdSupport ? this : new FeatureSet(this.hasBatchingSupport, elementIdSupport, this.requiredVersion);
        }

        public FeatureSet withRequiredVersion(String newRequiredVersion) {
            return Objects.equals(this.requiredVersion, newRequiredVersion) ? this : new FeatureSet(this.hasBatchingSupport, this.hasElementIdSupport, newRequiredVersion);
        }
    }
}

