/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationChain;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationVersion;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.neo4j.driver.Query;
import org.neo4j.driver.Values;

final class ChainTool {
    private final Map<MigrationVersion, Migration> discoveredMigrations;
    private final MigrationChain newChain;
    private final Map<MigrationVersion, MigrationChain.Element> newElements;
    private final Map<MigrationVersion, MigrationChain.Element> currentElements;

    ChainTool(Collection<Migration> discoveredMigrations, MigrationChain newChain, MigrationChain currentChain) {
        this.newChain = newChain;
        this.discoveredMigrations = discoveredMigrations.stream().collect(Collectors.toMap(Migration::getVersion, Function.identity()));
        Collector<MigrationChain.Element, ?, TreeMap> collector = Collectors.toMap(e -> MigrationVersion.withValue(e.getVersion()), Function.identity(), ChainTool.throwingMerger(), () -> new TreeMap(new MigrationVersion.VersionComparator()));
        this.newElements = newChain.getElements().stream().collect(collector);
        this.currentElements = currentChain.getElements().stream().collect(collector);
    }

    List<Query> repair(MigrationsConfig config, MigrationContext context) {
        if (this.currentElements.isEmpty()) {
            return List.of();
        }
        String migrationTarget = config.getMigrationTargetIn(context).orElse(null);
        ArrayList<Query> result = new ArrayList<Query>(this.fixChecksums(migrationTarget));
        result.addAll(this.deleteLocallyMissingMigrations(migrationTarget));
        result.addAll(this.insertRemoteMissingMigrations(migrationTarget, config.getOptionalInstalledBy()));
        return result;
    }

    static Query generateMigrationDeletionQuery(String migrationTarget, MigrationVersion version) {
        String cypher = "MATCH (p)-[l:MIGRATED_TO]->(m:__Neo4jMigration {version: $version})\nOPTIONAL MATCH (m)-[r:MIGRATED_TO]->(n:__Neo4jMigration)\nWHERE coalesce(m.migrationTarget, '<default>') = coalesce($migrationTarget,'<default>')\nWITH p, l, m, r, n\nFOREACH (i in CASE WHEN n IS NOT NULL THEN [1] ELSE [] END |\n  CREATE (p)-[nl:MIGRATED_TO]->(n)\n  SET nl = properties(l)\n)\nWITH l, m, r, properties(m) as p\nDELETE l, m, r\nRETURN p\n";
        return new Query(cypher, Values.parameters((Object[])new Object[]{"version", version.getValue(), "migrationTarget", migrationTarget}));
    }

    private List<Query> fixChecksums(String migrationTarget) {
        String cypher = "MATCH (m:__Neo4jMigration {version: $version, checksum: $oldChecksum})\nWHERE coalesce(m.migrationTarget, '<default>') = coalesce($migrationTarget,'<default>')\nSET m.checksum = $newChecksum\n";
        Predicate<Pair> withChecksumFilter = Pair::checksumDiffers;
        withChecksumFilter = withChecksumFilter.and(Pair::hasChecksums);
        return this.findPairs().values().stream().filter(withChecksumFilter).map(p -> new Query(cypher, Values.parameters((Object[])new Object[]{"migrationTarget", migrationTarget, "version", p.e1.getVersion(), "oldChecksum", p.e2.getChecksum().orElseThrow(), "newChecksum", p.e1.getChecksum().orElseThrow()}))).toList();
    }

    private List<Query> deleteLocallyMissingMigrations(String migrationTarget) {
        return this.findMissingSourceElements().stream().map(version -> ChainTool.generateMigrationDeletionQuery(migrationTarget, version)).toList();
    }

    private List<Query> insertRemoteMissingMigrations(String migrationTarget, Optional<String> installedBy) {
        String cypher = "MATCH (pm:__Neo4jMigration {version: $previousVersion}) - [pr:MIGRATED_TO] -> (nm:__Neo4jMigration)\nWHERE coalesce(pm.migrationTarget, '<default>') = coalesce($migrationTarget,'<default>')\nAND coalesce(pm.migrationTarget, '<default>') = coalesce(nm.migrationTarget, '<default>')\nCREATE (im:__Neo4jMigration {version: $version})\nCREATE (pm)-[nl:MIGRATED_TO {at: datetime({timezone: 'UTC'}), in: duration( {milliseconds: 0} ), by: $installedBy, connectedAs: $neo4jUser}]-> (im)\nCREATE (im)-[nr:MIGRATED_TO]->(nm)\nSET im = $insertedMigration,  nr = properties(pr)\nDELETE pr\nRETURN *\n";
        MigrationVersion lastKnownVersion = (MigrationVersion)this.currentElements.keySet().stream().skip((long)this.currentElements.size() - 1L).findFirst().orElseThrow();
        MigrationVersion.VersionComparator comparator = new MigrationVersion.VersionComparator();
        TreeSet<MigrationVersion> allVersions = new TreeSet<MigrationVersion>(comparator);
        allVersions.add(MigrationVersion.baseline());
        allVersions.addAll(this.newElements.keySet());
        allVersions.addAll(this.currentElements.keySet());
        allVersions.removeAll(this.findMissingSourceElements());
        ArrayList<MigrationVersion> sortedVersions = new ArrayList<MigrationVersion>(allVersions);
        return this.newElements.entrySet().stream().takeWhile(entry -> comparator.compare((MigrationVersion)entry.getKey(), lastKnownVersion) < 0).filter(entry -> !this.currentElements.containsKey(entry.getKey())).map(entry -> {
            MigrationChain.Element migration = (MigrationChain.Element)entry.getValue();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("version", ((MigrationVersion)entry.getKey()).getValue());
            migration.getOptionalDescription().ifPresent(v -> properties.put("description", v));
            properties.put("type", migration.getType().name());
            properties.put("repeatable", Optional.ofNullable(this.discoveredMigrations.get(entry.getKey())).map(Migration::isRepeatable).orElse(false));
            properties.put("source", migration.getSource());
            migration.getChecksum().ifPresent(v -> properties.put("checksum", v));
            return new Query(cypher, Values.parameters((Object[])new Object[]{"migrationTarget", migrationTarget, "version", ((MigrationVersion)entry.getKey()).getValue(), "previousVersion", ((MigrationVersion)sortedVersions.get(sortedVersions.indexOf(entry.getKey()) - 1)).getValue(), "installedBy", installedBy.map(Values::value).orElse(Values.NULL), "neo4jUser", this.newChain.getUsername(), "insertedMigration", properties}));
        }).toList();
    }

    private Map<MigrationVersion, Pair> findPairs() {
        HashSet<MigrationVersion> sharedKeys = new HashSet<MigrationVersion>(this.newElements.keySet());
        sharedKeys.retainAll(this.currentElements.keySet());
        return sharedKeys.stream().collect(Collectors.toMap(Function.identity(), k -> new Pair(this.newElements.get(k), this.currentElements.get(k)), ChainTool.throwingMerger(), () -> new TreeMap(new MigrationVersion.VersionComparator())));
    }

    private Set<MigrationVersion> findMissingSourceElements() {
        return this.currentElements.keySet().stream().filter(element -> !this.newElements.containsKey(element)).collect(Collectors.toSet());
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (k, v) -> {
            throw new IllegalStateException("Must not contain duplicate keys");
        };
    }

    record Pair(MigrationChain.Element e1, MigrationChain.Element e2) {
        boolean checksumDiffers() {
            return !this.e1.getChecksum().equals(this.e2.getChecksum());
        }

        boolean hasChecksums() {
            return this.e1.getChecksum().isPresent() && this.e2.getChecksum().isPresent();
        }
    }
}

