/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.MigrationChainFormat;
import java.util.Optional;

enum ConnectionDetailsFormatter {
    INSTANCE;


    String format(ConnectionDetails cd) {
        StringBuilder sb = new StringBuilder();
        sb.append(MigrationChainFormat.LS).append(cd.getUsername()).append("@").append(cd.getServerAddress()).append(" (").append(cd.getServerVersion());
        if (cd.getServerEdition() != null) {
            sb.append(" ").append(cd.getServerEdition()).append(" Edition)");
        } else {
            sb.append(")");
        }
        Optional<String> optionalDatabase = cd.getOptionalDatabaseName();
        optionalDatabase.ifPresent(name -> sb.append(MigrationChainFormat.LS).append("Database: ").append((String)name));
        Optional<String> optionalSchemaDatabase = cd.getOptionalSchemaDatabaseName();
        if (!optionalSchemaDatabase.equals(optionalDatabase)) {
            optionalSchemaDatabase.ifPresent(name -> sb.append(MigrationChainFormat.LS).append("Schema database: ").append((String)name));
        }
        return sb.toString();
    }
}

