/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;

final class IterableMigrations
implements Iterable<Migration> {
    private final MigrationsConfig config;
    private final List<Migration> migrations;

    IterableMigrations(MigrationsConfig config, List<Migration> migrations) {
        this.config = config;
        this.migrations = migrations;
    }

    @Override
    public Iterator<Migration> iterator() {
        Iterator<Migration> iterator = this.migrations.iterator();
        return this.config.getOptionalDelayBetweenMigrations().map(d -> new DelayingIterator(iterator, (Duration)d)).orElse(iterator);
    }

    private static final class DelayingIterator
    implements Iterator<Migration> {
        private final Iterator<Migration> delegate;
        private final Duration delay;

        DelayingIterator(Iterator<Migration> delegate, Duration delay) {
            this.delegate = delegate;
            this.delay = delay;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Migration next() {
            try {
                Thread.sleep(this.delay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.delegate.next();
        }
    }
}

