/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.MigrationsException;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MigrationVersion {
    private static final String BASELINE_VALUE = "BASELINE";
    private static final MigrationVersion BASELINE = new MigrationVersion("BASELINE", null, false);
    static final Pattern VERSION_PATTERN = Pattern.compile("(?<type>[VR])(?<version>\\d+(?:_\\d+)*+|\\d+(?:\\.\\d+)*+)__(?<name>[\\w ]+)(?:\\.(?<ext>\\w+))?");
    private final String value;
    private final String description;
    private final boolean repeatable;

    public static boolean canParse(String pathOrUrl) {
        return VERSION_PATTERN.matcher(pathOrUrl).find();
    }

    static MigrationVersion of(Class<?> clazz) {
        return MigrationVersion.parse(clazz.getSimpleName());
    }

    public static MigrationVersion parse(String name) {
        Matcher matcher = VERSION_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new MigrationsException("Invalid class name for a migration: " + name);
        }
        boolean repeatable = "R".equalsIgnoreCase(matcher.group("type"));
        return new MigrationVersion(matcher.group("version").replace("_", "."), matcher.group("name").replace("_", " "), repeatable);
    }

    public static MigrationVersion withValue(String value) {
        return MigrationVersion.withValue(value, false);
    }

    static MigrationVersion withValue(String value, boolean repeatable) {
        return MigrationVersion.withValueAndDescription(value, null, repeatable);
    }

    static MigrationVersion withValueAndDescription(String value, String description, boolean repeatable) {
        if (BASELINE_VALUE.equals(value)) {
            return MigrationVersion.baseline();
        }
        return new MigrationVersion(value, description, repeatable);
    }

    static MigrationVersion baseline() {
        return BASELINE;
    }

    private MigrationVersion(String value, String description, boolean repeatable) {
        this.value = value;
        this.description = description;
        this.repeatable = repeatable;
    }

    public String getValue() {
        return this.value;
    }

    boolean isRepeatable() {
        return this.repeatable;
    }

    Optional<String> getOptionalDescription() {
        return Optional.ofNullable(this.description);
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersion that = (MigrationVersion)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static class VersionComparator
    implements Comparator<MigrationVersion> {
        VersionComparator() {
        }

        @Override
        public int compare(MigrationVersion o1, MigrationVersion o2) {
            if (o1 == MigrationVersion.baseline() && o2 == MigrationVersion.baseline()) {
                return 0;
            }
            if (o1 == MigrationVersion.baseline() || o2 == MigrationVersion.baseline()) {
                return 1;
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

