/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractRepairmentResult;

public final class RepairmentResult
extends AbstractRepairmentResult {
    private final Outcome outcome;

    static RepairmentResult unnecessary(String affectedDatabase) {
        return new RepairmentResult(affectedDatabase, 0L, 0L, 0L, 0L, 0L, Outcome.NO_REPAIRMENT_NECESSARY);
    }

    static RepairmentResult repaired(String affectedDatabase, long nodesDeleted, long nodesCreated, long relationshipsDeleted, long relationshipsCreated, long propertiesSet) {
        return new RepairmentResult(affectedDatabase, nodesDeleted, nodesCreated, relationshipsDeleted, relationshipsCreated, propertiesSet, Outcome.REPAIRED);
    }

    private RepairmentResult(String affectedDatabase, long nodesDeleted, long nodesCreated, long relationshipsDeleted, long relationshipsCreated, long propertiesSet, Outcome outcome) {
        super(affectedDatabase, nodesDeleted, nodesCreated, relationshipsDeleted, relationshipsCreated, propertiesSet);
        this.outcome = outcome;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    @Override
    public String prettyPrint() {
        if (this.outcome == Outcome.NO_REPAIRMENT_NECESSARY) {
            return String.format("%s is in a valid state, missing or new migrations can be applied", this.getAffectedDatabase().map(v -> "`" + v + "`").orElse("The default database"));
        }
        return String.format("The migration chain in %s has been repaired: %d nodes and %d relationships have been deleted, %d nodes and %d relationships have been recreated.", this.getAffectedDatabase().map(v -> "`" + v + "`").orElse("the default database"), this.getNodesDeleted(), this.getRelationshipsDeleted(), this.getNodesCreated(), this.getRelationshipsCreated());
    }

    public static enum Outcome {
        NO_REPAIRMENT_NECESSARY,
        REPAIRED;

    }
}

