/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Migration;
import ac.simons.neo4j.migrations.core.Ordered;
import ac.simons.neo4j.migrations.core.ResourceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ServiceLoader;

public interface ResourceBasedMigrationProvider
extends Ordered {
    public static Collection<ResourceBasedMigrationProvider> unique() {
        HashMap<String, ResourceBasedMigrationProvider> providers = new HashMap<String, ResourceBasedMigrationProvider>();
        ServiceLoader<ResourceBasedMigrationProvider> loader = ServiceLoader.load(ResourceBasedMigrationProvider.class);
        for (ResourceBasedMigrationProvider provider : loader) {
            String extension = provider.getExtension();
            if (providers.containsKey(extension) && ((ResourceBasedMigrationProvider)providers.get(extension)).getOrder() < provider.getOrder()) continue;
            providers.put(extension, provider);
        }
        return Collections.unmodifiableCollection(providers.values());
    }

    public String getExtension();

    public Collection<Migration> handle(ResourceContext var1);

    default public boolean supportsArbitraryResourceNames() {
        return false;
    }
}

