/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.CatalogDiff;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class CatalogDiffImpl
implements CatalogDiff {
    private final boolean identical;
    private final boolean equivalent;
    private final Collection<CatalogItem<?>> itemsOnlyInLeft;
    private final Collection<CatalogItem<?>> itemsOnlyInRight;
    private final Collection<CatalogItem<?>> equivalentItems;

    CatalogDiffImpl() {
        this(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    CatalogDiffImpl(Set<CatalogItem<?>> itemsOnlyInLeft, Set<CatalogItem<?>> itemsOnlyInRight, Set<CatalogItem<?>> equivalentItems) {
        this.itemsOnlyInLeft = itemsOnlyInLeft;
        this.itemsOnlyInRight = itemsOnlyInRight;
        this.equivalentItems = equivalentItems;
        this.identical = itemsOnlyInLeft.isEmpty() && itemsOnlyInRight.isEmpty();
        this.equivalent = this.identical || this.equivalentItems.containsAll(itemsOnlyInLeft) && this.equivalentItems.containsAll(itemsOnlyInRight);
    }

    @Override
    public boolean identical() {
        return this.identical;
    }

    @Override
    public boolean equivalent() {
        return this.equivalent;
    }

    @Override
    public Collection<CatalogItem<?>> getItemsOnlyInLeft() {
        return Collections.unmodifiableCollection(this.itemsOnlyInLeft);
    }

    @Override
    public Collection<CatalogItem<?>> getItemsOnlyInRight() {
        return Collections.unmodifiableCollection(this.itemsOnlyInRight);
    }

    @Override
    public Collection<CatalogItem<?>> getEquivalentItems() {
        return Collections.unmodifiableCollection(this.equivalentItems);
    }
}

