/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import ac.simons.neo4j.migrations.core.catalog.Renderer;
import ac.simons.neo4j.migrations.core.internal.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

enum CatalogToXMLRenderer implements Renderer<Catalog>
{
    INSTANCE;


    @Override
    public void render(Catalog catalog, RenderConfig config, OutputStream target) throws IOException {
        List<RenderConfig.XMLRenderingOptions> relevantOptions = config.getAdditionalOptions().stream().filter(RenderConfig.XMLRenderingOptions.class::isInstance).map(RenderConfig.XMLRenderingOptions.class::cast).toList();
        boolean withApply = relevantOptions.stream().map(RenderConfig.XMLRenderingOptions::withApply).reduce(!relevantOptions.isEmpty(), (v1, v2) -> v1 != false && v2 != false);
        boolean withReset = relevantOptions.stream().map(RenderConfig.XMLRenderingOptions::withReset).reduce(!relevantOptions.isEmpty(), (v1, v2) -> v1 != false && v2 != false);
        String header = relevantOptions.stream().map(RenderConfig.XMLRenderingOptions::optionalHeader).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(System.lineSeparator(), " ", " "));
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element migrationElement = document.createElementNS("https://michael-simons.github.io/neo4j-migrations", "migration");
            if (!header.trim().isEmpty()) {
                migrationElement.appendChild(document.createComment(header));
            }
            document.appendChild(migrationElement);
            Element catalogElement = document.createElement("catalog");
            if (withReset) {
                catalogElement.setAttribute("reset", Boolean.toString(true));
            }
            Element indexesElement = document.createElement("indexes");
            migrationElement.appendChild(catalogElement);
            catalogElement.appendChild(indexesElement);
            Element constraintsElement = document.createElement("constraints");
            catalogElement.appendChild(constraintsElement);
            for (CatalogItem<?> item : catalog.getItems()) {
                if (item instanceof Constraint) {
                    Constraint constraint = (Constraint)item;
                    constraintsElement.appendChild(constraint.toXML(document));
                    continue;
                }
                if (!(item instanceof Index)) continue;
                Index index = (Index)item;
                indexesElement.appendChild(index.toXML(document));
            }
            if (withApply) {
                Element apply = document.createElement("apply");
                migrationElement.appendChild(apply);
            }
            XMLUtils.getIndentingTransformer().transform(new DOMSource(document), new StreamResult(target));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException(e);
        }
    }
}

