/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.AbstractCatalogItem;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.ItemType;
import ac.simons.neo4j.migrations.core.catalog.PropertyType;
import ac.simons.neo4j.migrations.core.catalog.TargetEntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Constraint
extends AbstractCatalogItem<Type> {
    private static final PatternHolder PATTERN_NODE_PROPERTY_IS_UNIQUE = new PatternHolder("CONSTRAINT ON \\(\\s?(?<var>\\w+):(?<identifier>\\w+)\\s?\\) ASSERT \\(?\\k<var>\\.(?<properties>.+?)\\)? IS UNIQUE", Type.UNIQUE, TargetEntityType.NODE);
    private static final PatternHolder PATTERN_NODE_PROPERTY_EXISTS = new PatternHolder("CONSTRAINT ON \\(\\s?(?<var>\\w+):(?<identifier>\\w+)\\s?\\) ASSERT (?:exists)?\\((?<properties>\\k<var>\\..+?)\\)(?: IS NOT NULL)?", Type.EXISTS, TargetEntityType.NODE);
    private static final PatternHolder PATTERN_NODE_KEY = new PatternHolder("CONSTRAINT ON \\(\\s?(?<var>\\w+):(?<identifier>\\w+)\\s?\\) ASSERT \\((?<properties>\\k<var>\\..+?)\\) IS NODE KEY", Type.KEY, TargetEntityType.NODE);
    private static final PatternHolder PATTERN_REL_PROPERTY_EXISTS = new PatternHolder("CONSTRAINT ON \\(\\)-\\[\\s?(?<var>\\w+):(?<identifier>\\w+)\\s?]-\\(\\) ASSERT (?:exists)?\\((?<properties>\\k<var>\\..+?)\\)(?: IS NOT NULL)?", Type.EXISTS, TargetEntityType.RELATIONSHIP);
    private static final Set<String> REQUIRED_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("name", "type", "entityType", "labelsOrTypes", "properties")));
    private final PropertyType propertyType;

    public static NodeConstraintBuilder forNode(String label) {
        return new DefaultBuilder(TargetEntityType.NODE, label);
    }

    public static RelationshipConstraintBuilder forRelationship(String type) {
        return new DefaultBuilder(TargetEntityType.RELATIONSHIP, type);
    }

    public static Constraint parse(MapAccessor row) {
        Value descriptionValue = row.get("description");
        Value nameValue = row.get("name");
        if (descriptionValue != Values.NULL) {
            String name = nameValue != Values.NULL ? nameValue.asString() : null;
            return Constraint.parse(descriptionValue.asString(), name);
        }
        if (!REQUIRED_KEYS.stream().allMatch(arg_0 -> ((MapAccessor)row).containsKey(arg_0))) {
            throw new IllegalArgumentException("Required keys are missing in the row describing the constraint");
        }
        String name = nameValue.asString();
        Type type = switch (row.get("type").asString()) {
            case "NODE_KEY" -> Type.KEY;
            case "NODE_PROPERTY_EXISTENCE", "RELATIONSHIP_PROPERTY_EXISTENCE" -> Type.EXISTS;
            case "NODE_PROPERTY_TYPE", "RELATIONSHIP_PROPERTY_TYPE" -> Type.PROPERTY_TYPE;
            case "UNIQUENESS" -> Type.UNIQUE;
            default -> throw new IllegalArgumentException("Unsupported constraint type " + nameValue.asString());
        };
        TargetEntityType targetEntityType = TargetEntityType.valueOf(row.get("entityType").asString());
        List labelsOrTypes = row.get("labelsOrTypes").asList(Value::asString);
        List properties = row.get("properties").asList(Value::asString);
        String options = Constraint.resolveOptions(row).orElse(null);
        PropertyType propertyType = null;
        if (type == Type.PROPERTY_TYPE) {
            propertyType = PropertyType.parse(row.get("propertyType").asString());
        }
        return new Constraint(name, type, targetEntityType, (String)labelsOrTypes.get(0), new LinkedHashSet<String>(properties), options, propertyType);
    }

    public static Constraint parse(Element constraintElement) {
        Set<String> properties;
        String name = constraintElement.getAttribute("name");
        Type type = Type.valueOf(constraintElement.getAttribute("type").toUpperCase(Locale.ROOT).replace(" ", "_"));
        AbstractCatalogItem.Target target = Constraint.extractTarget(constraintElement);
        PropertyType propertyType = null;
        if (type == Type.PROPERTY_TYPE) {
            NodeList propertyNodes = ((Element)constraintElement.getElementsByTagName("properties").item(0)).getElementsByTagName("property");
            if (propertyNodes.getLength() > 1) {
                throw new IllegalArgumentException("Only one property allowed on property type constraints.");
            }
            Node typeAttribute = propertyNodes.item(0).getAttributes().getNamedItem("type");
            if (typeAttribute == null || typeAttribute.getTextContent().isBlank()) {
                throw new IllegalArgumentException("The type attribute for properties is required on property type constraints.");
            }
            propertyType = PropertyType.parse(typeAttribute.getTextContent());
            properties = Set.of(propertyNodes.item(0).getTextContent());
        } else {
            properties = Constraint.extractProperties(constraintElement);
        }
        String options = Constraint.extractOptions(constraintElement);
        if (target.targetEntityType() == TargetEntityType.RELATIONSHIP && type != Type.EXISTS) {
            throw new IllegalArgumentException("Only existential constraints are supported for relationships");
        }
        return new Constraint(name, type, target.targetEntityType(), target.identifier(), properties, options, propertyType);
    }

    private static Constraint parse(String description, String name) {
        for (PatternHolder patternHolder : new PatternHolder[]{PATTERN_NODE_PROPERTY_IS_UNIQUE, PATTERN_NODE_PROPERTY_EXISTS, PATTERN_NODE_KEY, PATTERN_REL_PROPERTY_EXISTS}) {
            Matcher matcher = patternHolder.pattern.matcher(description);
            if (!matcher.matches()) continue;
            String identifier = matcher.group("identifier").trim();
            String variable = Pattern.quote(matcher.group("var") + ".");
            String propertiesGroup = matcher.group("properties");
            Stream<String> propertiesStream = patternHolder.type == Type.KEY ? Arrays.stream(propertiesGroup.split(", ")).map(String::trim) : Stream.of(propertiesGroup.trim());
            String[] properties = (String[])propertiesStream.map(s -> s.replaceFirst(variable, "")).toArray(String[]::new);
            return new Constraint(name, patternHolder.type, patternHolder.targetEntityType, identifier, (Collection<String>)new LinkedHashSet<String>(Arrays.asList(properties)), null);
        }
        throw new IllegalArgumentException(String.format("The description '%s' does not match any known pattern.", description));
    }

    Constraint(Type type, TargetEntityType targetEntityType, String identifier, Collection<String> properties, PropertyType propertyType) {
        this(null, type, targetEntityType, identifier, properties, null, propertyType);
    }

    Constraint(String name, Type type, TargetEntityType targetEntityType, String identifier, Collection<String> properties, PropertyType propertyType) {
        this(name, type, targetEntityType, identifier, properties, null, propertyType);
    }

    Constraint(String name, Type type, TargetEntityType targetEntityType, String identifier, Collection<String> properties, String options, PropertyType propertyType) {
        super(name, type, targetEntityType, identifier, properties, options);
        if (type == Type.KEY && this.getTargetEntityType() != TargetEntityType.NODE) {
            throw new IllegalArgumentException("Key constraints are only supported for nodes, not for relationships.");
        }
        if (propertyType != null && type != Type.PROPERTY_TYPE) {
            throw new IllegalArgumentException("A property type can only be used with a property type constraint.");
        }
        if (type == Type.PROPERTY_TYPE && propertyType == null) {
            throw new IllegalArgumentException("A property type constraint requires a property type.");
        }
        if (propertyType != null && properties.size() != 1) {
            throw new IllegalArgumentException("A property type constraint can only be applied to a single property.");
        }
        this.propertyType = propertyType;
    }

    public Constraint withOptions(String options) {
        if (Objects.equals(this.options, options)) {
            return this;
        }
        return new Constraint(this.getName().getValue(), (Type)this.getType(), this.getTargetEntityType(), this.getIdentifier(), this.getProperties(), options, this.propertyType);
    }

    public Constraint withName(String name) {
        if (Objects.equals(super.getName().getValue(), name)) {
            return this;
        }
        return new Constraint(name, (Type)this.getType(), this.getTargetEntityType(), this.getIdentifier(), this.getProperties(), this.options, this.propertyType);
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public boolean isEquivalentTo(CatalogItem<?> that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Constraint)) {
            return false;
        }
        Constraint other = (Constraint)that;
        return ((Type)this.getType()).equals(other.getType()) && this.getTargetEntityType().equals((Object)other.getTargetEntityType()) && this.getIdentifier().equals(other.getIdentifier()) && this.getProperties().equals(other.getProperties());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Constraint that = (Constraint)o;
        return this.propertyType == that.propertyType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.propertyType});
    }

    private static class DefaultBuilder
    implements NodeConstraintBuilder,
    RelationshipConstraintBuilder,
    ConstraintsForNodes {
        private final TargetEntityType targetEntityType;
        private final String identifier;
        private String name;

        private DefaultBuilder(TargetEntityType targetEntityType, String identifier) {
            this.targetEntityType = targetEntityType;
            this.identifier = identifier;
        }

        @Override
        public ConstraintsForNodes named(String newName) {
            this.name = newName;
            return this;
        }

        @Override
        public Constraint unique(String ... properties) {
            return new Constraint(this.name, Type.UNIQUE, this.targetEntityType, this.identifier, (Collection<String>)Arrays.asList(properties), null);
        }

        @Override
        public Constraint exists(String property) {
            return new Constraint(this.name, Type.EXISTS, this.targetEntityType, this.identifier, (Collection<String>)Collections.singleton(property), null);
        }

        @Override
        public Constraint key(String ... properties) {
            return new Constraint(this.name, Type.KEY, this.targetEntityType, this.identifier, (Collection<String>)Arrays.asList(properties), null);
        }

        @Override
        public Constraint type(String property, PropertyType type) {
            return new Constraint(this.name, Type.PROPERTY_TYPE, this.targetEntityType, this.identifier, Collections.singleton(property), type);
        }
    }

    public static enum Type implements ItemType
    {
        UNIQUE,
        EXISTS,
        KEY,
        PROPERTY_TYPE;


        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static class PatternHolder {
        private final Pattern pattern;
        private final Type type;
        private final TargetEntityType targetEntityType;

        PatternHolder(String pattern, Type type, TargetEntityType targetEntityType) {
            this.pattern = Pattern.compile(pattern, 2);
            this.type = type;
            this.targetEntityType = targetEntityType;
        }
    }

    public static interface ConstraintsForNodes
    extends CommonConstraints {
        public Constraint unique(String ... var1);

        public Constraint key(String ... var1);
    }

    public static interface CommonConstraints {
        public Constraint exists(String var1);

        public Constraint type(String var1, PropertyType var2);
    }

    public static interface RelationshipConstraintBuilder {
        public CommonConstraints named(String var1);
    }

    public static interface NodeConstraintBuilder {
        public ConstraintsForNodes named(String var1);
    }
}

