/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import ac.simons.neo4j.migrations.core.catalog.GeneratedName;
import ac.simons.neo4j.migrations.core.catalog.Name;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;

final class FormattableCatalogItem
implements Formattable {
    private final CatalogItem<?> delegate;
    private final Neo4jVersion version;

    FormattableCatalogItem(CatalogItem<?> delegate, Neo4jVersion version) {
        this.delegate = delegate;
        this.version = version;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        Appendable out = formatter.out();
        try {
            out.append(this.delegate.getClass().getSimpleName().toUpperCase(Locale.ROOT));
            Name name = this.delegate.getName();
            if (!(name instanceof GeneratedName)) {
                out.append(' ').append(this.version.sanitizeSchemaName(name.getValue()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

