/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.DefaultName;
import ac.simons.neo4j.migrations.core.catalog.GeneratedName;
import ac.simons.neo4j.migrations.core.catalog.ItemType;
import ac.simons.neo4j.migrations.core.catalog.TargetEntityType;
import ac.simons.neo4j.migrations.core.internal.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Name {
    public static Name of(String value) {
        return value == null ? DefaultName.EMPTY : new DefaultName(value);
    }

    public static Name generate(Class<?> classType, ItemType itemType, TargetEntityType targetEntityType, String identifier, Collection<String> properties, String options) {
        String src = String.format("{type=%s, targetEntity=%s, identifier='%s', properties='%s'%s}", new Object[]{itemType, targetEntityType, identifier, String.join((CharSequence)",", properties), options == null ? "" : ", options='" + options + "'"});
        String value = String.format("%s_%s", classType.getSimpleName(), Strings.MD5.andThen(Strings.BASE64_ENCODING).apply(src.getBytes(StandardCharsets.UTF_8)));
        return new GeneratedName(value);
    }

    public String getValue();
}

