/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.internal;

import ac.simons.neo4j.migrations.core.internal.UncheckedNoSuchAlgorithmException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    public static final String CYPHER_SINGLE_LINE_COMMENT = "//";
    public static final String LINE_DELIMITER = "\r?\n|\r";
    public static final UnaryOperator<byte[]> MD5 = bytes -> {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return md5.digest((byte[])bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedNoSuchAlgorithmException(e);
        }
    };
    public static final String VALID_DATABASE_NAME = "([a-z][a-z\\d.\\-]{2,62})";
    private static final HexFormat HEX_FORMAT = HexFormat.of().withUpperCase();
    public static final Function<byte[], String> BASE64_ENCODING = HEX_FORMAT::formatHex;

    public static String capitalize(String value) {
        char updatedChar;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char baseChar = value.charAt(0);
        if (baseChar == (updatedChar = Character.toUpperCase(baseChar))) {
            return value;
        }
        char[] chars = value.toCharArray();
        chars[0] = updatedChar;
        return new String(chars, 0, chars.length);
    }

    public static String toCamelCase(String value) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int u = 95;
        Integer prev = null;
        boolean nextUpper = false;
        while (i < value.length()) {
            int codePoint = value.codePointAt(i);
            i += Character.charCount(codePoint);
            if (codePoint == 95) {
                nextUpper = true;
                continue;
            }
            UnaryOperator transform = Character::toLowerCase;
            if (nextUpper || prev != null && Character.isLowerCase(prev) && Character.isUpperCase(codePoint)) {
                transform = Character::toUpperCase;
            }
            prev = codePoint;
            sb.append(Character.toChars((Integer)transform.apply(codePoint)));
            nextUpper = false;
        }
        return sb.toString();
    }

    public static boolean isSingleLineComment(String statement) {
        Objects.requireNonNull(statement, "Statement to check must not be null");
        String trimmed = statement.trim();
        if (!trimmed.startsWith(CYPHER_SINGLE_LINE_COMMENT)) {
            return false;
        }
        return !trimmed.contains("\n") && !trimmed.contains("\r");
    }

    private static boolean valueIsNotBlank(String value) {
        return !value.trim().isEmpty();
    }

    public static Optional<String> optionalOf(String value) {
        return Optional.ofNullable(value).filter(Strings::valueIsNotBlank).map(String::trim);
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static String replaceElementIdCalls(String query) {
        String prefix = "toString(id(";
        String postfix = "))";
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("([\\s(]?)elementId\\((.+?)\\)").matcher(query);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + prefix + m.group(2) + postfix);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private Strings() {
    }
}

