/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.AbstractCustomizableRefactoring;
import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.DefaultCounters;
import ac.simons.neo4j.migrations.core.refactorings.Normalize;
import ac.simons.neo4j.migrations.core.refactorings.QueryRunner;
import ac.simons.neo4j.migrations.core.refactorings.RefactoringContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;

final class DefaultNormalize
extends AbstractCustomizableRefactoring
implements Normalize {
    private final String property;
    private final List<Object> trueValues;
    private final List<Object> falseValues;
    private final QueryRunner.FeatureSet featureSet;

    DefaultNormalize(String property, List<Object> trueValues, List<Object> falseValues) {
        this(property, trueValues, falseValues, null, null);
    }

    private DefaultNormalize(String property, List<Object> trueValues, List<Object> falseValues, String customQuery, Integer batchSize) {
        super(customQuery, batchSize);
        boolean nullIsTrue = trueValues.stream().anyMatch(DefaultNormalize::isNull);
        boolean nullIsFalse = falseValues.stream().anyMatch(DefaultNormalize::isNull);
        if (nullIsFalse && nullIsTrue) {
            throw new IllegalArgumentException("Both true and false values contain the literal value null");
        }
        trueValues.stream().filter(falseValues::contains).findFirst().ifPresent(v -> {
            throw new IllegalArgumentException("Both true and false values contain `" + v + "`");
        });
        this.property = property;
        this.trueValues = trueValues;
        this.falseValues = falseValues;
        this.featureSet = this.batchSize != null ? QueryRunner.defaultFeatureSet().withRequiredVersion("4.4").withBatchingSupport(true) : QueryRunner.defaultFeatureSet().withRequiredVersion("4.1");
    }

    static boolean isNull(Object v) {
        return v == null || Values.NULL.equals(v);
    }

    QueryRunner.FeatureSet getFeatures() {
        return this.featureSet;
    }

    @Override
    public Normalize inBatchesOf(Integer newBatchSize) {
        return this.inBatchesOf0(newBatchSize, DefaultNormalize.class, v -> new DefaultNormalize(this.property, this.trueValues, this.falseValues, this.customQuery, (Integer)v));
    }

    @Override
    public Normalize withCustomQuery(String newCustomQuery) {
        return this.withCustomQuery0(newCustomQuery, Normalize.class, v -> new DefaultNormalize(this.property, this.trueValues, this.falseValues, (String)v, this.batchSize));
    }

    @Override
    public Counters apply(RefactoringContext context) {
        try (QueryRunner queryRunner = context.getQueryRunner(this.featureSet);){
            DefaultCounters defaultCounters = new DefaultCounters(queryRunner.run(this.generateQuery(context::sanitizeSchemaName, context::findSingleResultIdentifier)).consume().counters());
            return defaultCounters;
        }
    }

    Query generateQuery(UnaryOperator<String> sanitizer, Function<String, Optional<String>> elementExtractor) {
        String innerQuery;
        String varName;
        List<Object> tv = this.trueValues;
        List<Object> fv = this.falseValues;
        Boolean nullValue = null;
        Predicate<Object> isNull = DefaultNormalize::isNull;
        if (this.trueValues.stream().anyMatch(isNull)) {
            nullValue = true;
            tv = this.trueValues.stream().filter(isNull.negate()).toList();
        } else if (this.falseValues.stream().anyMatch(DefaultNormalize::isNull)) {
            nullValue = false;
            fv = this.falseValues.stream().filter(isNull.negate()).toList();
        }
        if (this.customQuery == null) {
            varName = "t";
            innerQuery = "MATCH (n) RETURN n AS t UNION ALL MATCH ()-[r]->() RETURN r AS t";
        } else {
            varName = elementExtractor.apply(this.customQuery).orElseThrow(IllegalArgumentException::new);
            innerQuery = this.customQuery;
        }
        String quotedProperty = (String)sanitizer.apply(this.property);
        String formatString = "CALL { %2$s } WITH %3$s AS e\n<FILTER />\n<BATCH>SET e.%1$s = CASE\n  WHEN e.%1$s IN $trueValues THEN true\n  WHEN e.%1$s IN $falseValues THEN false\n  WHEN e.%1$s IN [true, false] THEN e.%1$s\n  ELSE $nullValue\nEND</BATCH>";
        formatString = this.batchSize == null ? formatString.replaceAll("<BATCH>|</BATCH>", "") : formatString.replace("<BATCH>", "CALL { WITH e ").replace("</BATCH>", " } IN TRANSACTIONS OF %4$d ROWS");
        formatString = formatString.replace("<FILTER />\n", nullValue == null ? "WHERE e.%1$s IS NOT NULL\n" : "");
        Map<String, Value> parameters = Map.of("trueValues", Values.value(tv), "falseValues", Values.value(fv), "nullValue", Values.value((Object)nullValue));
        return new Query(String.format(formatString, quotedProperty, innerQuery, varName, this.batchSize), parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNormalize that = (DefaultNormalize)o;
        return this.property.equals(that.property) && this.trueValues.equals(that.trueValues) && this.falseValues.equals(that.falseValues) && Objects.equals(this.customQuery, that.customQuery) && Objects.equals(this.batchSize, that.batchSize);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.trueValues, this.falseValues, this.customQuery, this.batchSize);
    }
}

