/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Callback;
import ac.simons.neo4j.migrations.core.CypherResource;
import ac.simons.neo4j.migrations.core.DefaultCypherResource;
import ac.simons.neo4j.migrations.core.LifecycleEvent;
import ac.simons.neo4j.migrations.core.LifecyclePhase;
import ac.simons.neo4j.migrations.core.MigrationsException;
import java.net.URL;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.SessionConfig;

final class CypherBasedCallback
implements Callback {
    private static final Logger LOGGER = Logger.getLogger(CypherBasedCallback.class.getName());
    private final CypherResource cypherResource;
    private final LifecyclePhase phase;
    private final String description;

    CypherBasedCallback(URL url, boolean autocrlf) {
        this.cypherResource = CypherResource.of(url, autocrlf);
        String script = this.cypherResource.getIdentifier();
        Matcher matcher = LifecyclePhase.LIFECYCLE_PATTERN.matcher(script);
        if (!matcher.matches()) {
            throw new MigrationsException("Invalid name for a callback script: " + script);
        }
        this.phase = LifecyclePhase.fromCamelCase(matcher.group(1));
        String optionalDescription = matcher.group(2);
        this.description = optionalDescription == null ? null : optionalDescription.trim().replace("_", " ");
    }

    @Override
    public LifecyclePhase getPhase() {
        return this.phase;
    }

    @Override
    public Optional<String> getOptionalDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public String getSource() {
        return this.cypherResource.getIdentifier();
    }

    @Override
    public void on(LifecycleEvent event) {
        LOGGER.log(Level.FINE, "Invoking \"{0}\" on {1}", new Object[]{this.cypherResource.getIdentifier(), event.getPhase()});
        UnaryOperator<SessionConfig.Builder> sessionCustomizer = event.getPhase() == LifecyclePhase.BEFORE_FIRST_USE ? builder -> SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE) : UnaryOperator.identity();
        DefaultCypherResource.executeIn(this.cypherResource, event.getContext(), sessionCustomizer);
    }
}

