/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Neo4jVersion;
import ac.simons.neo4j.migrations.core.internal.Strings;
import ac.simons.neo4j.migrations.core.refactorings.QueryRunner;
import ac.simons.neo4j.migrations.core.refactorings.RefactoringContext;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ResultSummary;

final class DefaultRefactoringContext
implements RefactoringContext {
    static final Pattern OP_PRODUCE_RESULT_PATTERN = Pattern.compile("(?i)ProduceResults(@([a-z][a-z\\d.\\-]{2,62}))?");
    static final String KEY_DETAILS = "Details";
    private final Supplier<Session> sessionSupplier;
    private volatile Neo4jVersion version;

    DefaultRefactoringContext(Supplier<Session> sessionSupplier) {
        this(sessionSupplier, null);
    }

    DefaultRefactoringContext(Supplier<Session> sessionSupplier, Neo4jVersion neo4jVersion) {
        this.sessionSupplier = sessionSupplier;
        this.version = neo4jVersion;
    }

    Query adaptQuery(Query query) {
        if (this.getVersion().getMajorVersion() >= 5) {
            return query;
        }
        return query.withText(Strings.replaceElementIdCalls(query.text()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Neo4jVersion getVersion() {
        Neo4jVersion availableVersion = this.version;
        if (availableVersion == null) {
            DefaultRefactoringContext defaultRefactoringContext = this;
            synchronized (defaultRefactoringContext) {
                availableVersion = this.version;
                if (availableVersion == null) {
                    String value = ((Record)this.sessionSupplier.get().executeRead(tx -> tx.run(new Query("CALL dbms.components() YIELD versions RETURN versions[0] AS version")).single())).get("version").asString();
                    availableVersion = this.version = Neo4jVersion.of(value);
                }
            }
        }
        return availableVersion;
    }

    @Override
    public QueryRunner getQueryRunner(QueryRunner.FeatureSet featureSet) {
        Neo4jVersion currentVersion = this.getVersion();
        if (currentVersion == Neo4jVersion.UNDEFINED) {
            throw new IllegalStateException("Cannot apply refactorings with an undefined version");
        }
        boolean supportsBatching = true;
        if (currentVersion != Neo4jVersion.LATEST) {
            Neo4jVersion requiredVersion = Neo4jVersion.of(featureSet.requiredVersion());
            if (requiredVersion == Neo4jVersion.UNDEFINED) {
                throw new IllegalArgumentException("Undefined version requested");
            }
            if (currentVersion.compareTo(requiredVersion) < 0) {
                throw new IllegalArgumentException("Supported version is " + currentVersion + " which is below the required value of " + requiredVersion);
            }
            boolean bl = supportsBatching = currentVersion.compareTo(Neo4jVersion.V4_4) >= 0;
        }
        if (featureSet.hasBatchingSupport() && !supportsBatching) {
            throw new IllegalArgumentException("Batching is supported only with Neo4j >= 4.4");
        }
        return new DefaultQueryRunner(featureSet, this.sessionSupplier.get(), featureSet.hasElementIdSupport() ? this::adaptQuery : UnaryOperator.identity());
    }

    @Override
    public Optional<String> findSingleResultIdentifier(String query) {
        try (Session session = this.sessionSupplier.get();){
            ResultSummary resultSummary = (ResultSummary)session.executeRead(tx -> tx.run(new Query("EXPLAIN " + query)).consume());
            Plan root = resultSummary.plan();
            if (DefaultRefactoringContext.isProduceResultOperator(root) && DefaultRefactoringContext.hasSingleElement(root)) {
                Optional<String> optional = Optional.of(((Value)root.arguments().get(KEY_DETAILS)).asString());
                return optional;
            }
        }
        return Optional.empty();
    }

    static boolean isProduceResultOperator(Plan plan) {
        return OP_PRODUCE_RESULT_PATTERN.matcher(plan.operatorType()).matches();
    }

    static boolean hasSingleElement(Plan plan) {
        Value details = plan.arguments().getOrDefault(KEY_DETAILS, Values.NULL);
        if (details.isNull()) {
            return false;
        }
        Predicate<String> nullOrBlank = s -> s == null || s.trim().isEmpty();
        Predicate<String> isExactlyDetails = s -> details.asString().equals(s);
        return plan.identifiers().stream().filter(nullOrBlank.negate().and(isExactlyDetails)).count() == 1L;
    }

    @Override
    public String sanitizeSchemaName(String potentiallyNonIdentifier) {
        return this.getVersion().sanitizeSchemaName(potentiallyNonIdentifier);
    }

    static final class DefaultQueryRunner
    implements QueryRunner {
        private final Session session;
        private final Transaction transaction;
        private final UnaryOperator<Query> filter;
        private final org.neo4j.driver.QueryRunner delegate;

        DefaultQueryRunner(QueryRunner.FeatureSet featureSet, Session session, UnaryOperator<Query> filter) {
            this.session = session;
            this.transaction = featureSet.hasBatchingSupport() ? null : session.beginTransaction();
            this.filter = filter;
            this.delegate = this.transaction == null ? session : this.transaction;
        }

        @Override
        public Result run(Query query) {
            return this.delegate.run((Query)this.filter.apply(query));
        }

        @Override
        public void close() {
            if (this.transaction != null) {
                this.transaction.commit();
                this.transaction.close();
            }
            this.session.close();
        }
    }
}

