/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.AbstractPrecondition;
import ac.simons.neo4j.migrations.core.ConnectionDetails;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.Neo4jEdition;
import ac.simons.neo4j.migrations.core.Precondition;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EditionPrecondition
extends AbstractPrecondition
implements Precondition {
    private static final Pattern CONDITION_PATTERN = Pattern.compile("(?i)^ *+// *+(?:assume|assert) that edition is *(?<edition>\\w++)?$");
    private final Neo4jEdition edition;

    static Optional<Function<Precondition.Type, Precondition>> tryToParse(String hint) {
        Matcher matcher = CONDITION_PATTERN.matcher(hint);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        try {
            Neo4jEdition edition = Neo4jEdition.of(matcher.group("edition"), false);
            return Optional.of(type -> new EditionPrecondition((Precondition.Type)((Object)type), edition));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Wrong edition precondition %s. Usage: `<assume|assert> that edition is <enterprise|community>`.", Precondition.formattedHint(hint)));
        }
    }

    static Neo4jEdition getEdition(ConnectionDetails connectionDetails) {
        return Neo4jEdition.of(connectionDetails.getServerEdition());
    }

    private EditionPrecondition(Precondition.Type type, Neo4jEdition edition) {
        super(type);
        this.edition = edition;
    }

    @Override
    public boolean isMet(MigrationContext migrationContext) {
        return EditionPrecondition.getEdition(migrationContext.getConnectionDetails()).equals((Object)this.edition);
    }

    Neo4jEdition getEdition() {
        return this.edition;
    }

    public String toString() {
        return String.format("// %s that edition is %s", this.getType().keyword(), this.getEdition().name());
    }
}

