/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.Discoverer;
import ac.simons.neo4j.migrations.core.JavaBasedMigration;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.MigrationsConfig;
import ac.simons.neo4j.migrations.core.MigrationsException;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class JavaBasedMigrationDiscoverer
implements Discoverer<JavaBasedMigration> {
    JavaBasedMigrationDiscoverer() {
    }

    @Override
    public Collection<JavaBasedMigration> discover(MigrationContext context) {
        MigrationsConfig config = context.getConfig();
        if (config.getPackagesToScan().length == 0) {
            return Collections.emptyList();
        }
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(config.getPackagesToScan()).enableExternalClasses().scan();){
            List<JavaBasedMigration> list = scanResult.getClassesImplementing(JavaBasedMigration.class.getName()).loadClasses(JavaBasedMigration.class).stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).map(c -> {
                try {
                    return (JavaBasedMigration)JavaBasedMigration.getDefaultConstructorFor(c).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new MigrationsException("Could not instantiate migration " + c.getName(), e);
                }
            }).toList();
            return list;
        }
    }
}

