/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core;

import ac.simons.neo4j.migrations.core.CypherResource;
import ac.simons.neo4j.migrations.core.EditionPrecondition;
import ac.simons.neo4j.migrations.core.MigrationContext;
import ac.simons.neo4j.migrations.core.QueryPrecondition;
import ac.simons.neo4j.migrations.core.VersionPrecondition;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

interface Precondition {
    public static Optional<Precondition> parse(String in) {
        return Type.of(in).flatMap(type -> {
            Optional<Function<Type, Precondition>> producer = VersionPrecondition.tryToParse(in);
            if (producer.isPresent()) {
                return producer.map(f -> (Precondition)f.apply(type));
            }
            producer = EditionPrecondition.tryToParse(in);
            if (producer.isPresent()) {
                return producer.map(f -> (Precondition)f.apply(type));
            }
            producer = QueryPrecondition.tryToParse(in);
            if (producer.isPresent()) {
                return producer.map(f -> (Precondition)f.apply(type));
            }
            throw new IllegalArgumentException("Wrong precondition " + Precondition.formattedHint(in) + ". Supported are `<assume|assert> (that <edition|version>)|q' <cypherQuery>)`.");
        });
    }

    public static List<Precondition> in(CypherResource cypherResource) {
        return cypherResource.getSingleLineComments().stream().map(Precondition::parse).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public boolean isMet(MigrationContext var1);

    public Type getType();

    public static String formattedHint(String hint) {
        return "`" + hint.replace("//", "").trim() + "`";
    }

    public static enum Type {
        ASSUMPTION("assume"),
        ASSERTION("assert");

        private final String keyword;
        private final Pattern pattern;

        private Type(String keyword) {
            this.keyword = keyword;
            this.pattern = Pattern.compile("(?i)// *" + keyword + "(?: in (?:schema|target))? (that|q').*");
        }

        String keyword() {
            return this.keyword;
        }

        static Optional<Type> of(String value) {
            if (Type.ASSUMPTION.pattern.matcher(value).find()) {
                return Optional.of(ASSUMPTION);
            }
            if (Type.ASSERTION.pattern.matcher(value).find()) {
                return Optional.of(ASSERTION);
            }
            return Optional.empty();
        }
    }
}

