/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogDiffImpl;
import ac.simons.neo4j.migrations.core.catalog.CatalogItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;

public interface CatalogDiff {
    public static CatalogDiff between(Catalog left, Catalog right) {
        if (left.isEmpty() && right.isEmpty()) {
            return new CatalogDiffImpl();
        }
        if (left.isEmpty() && !right.isEmpty()) {
            HashSet itemsOnlyInRight = new HashSet(right.getItems());
            return new CatalogDiffImpl(Collections.emptySet(), itemsOnlyInRight, Collections.emptySet());
        }
        if (!left.isEmpty() && right.isEmpty()) {
            HashSet itemsOnlyInLeft = new HashSet(left.getItems());
            return new CatalogDiffImpl(itemsOnlyInLeft, Collections.emptySet(), Collections.emptySet());
        }
        HashSet itemsOnlyInLeft = new HashSet(left.getItems());
        HashSet itemsOnlyInRight = new HashSet(right.getItems());
        itemsOnlyInLeft.removeAll(right.getItems());
        itemsOnlyInRight.removeAll(left.getItems());
        LinkedHashSet equivalentItems = new LinkedHashSet();
        for (CatalogItem catalogItem : itemsOnlyInLeft) {
            if (!right.getItems().stream().anyMatch(catalogItem::isEquivalentTo)) continue;
            equivalentItems.add(catalogItem);
        }
        for (CatalogItem catalogItem : itemsOnlyInRight) {
            if (!left.getItems().stream().anyMatch(catalogItem::isEquivalentTo)) continue;
            equivalentItems.add(catalogItem);
        }
        return new CatalogDiffImpl(itemsOnlyInLeft, itemsOnlyInRight, equivalentItems);
    }

    public boolean identical();

    public boolean equivalent();

    public Collection<CatalogItem<?>> getItemsOnlyInLeft();

    public Collection<CatalogItem<?>> getItemsOnlyInRight();

    public Collection<CatalogItem<?>> getEquivalentItems();
}

