/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.catalog;

import ac.simons.neo4j.migrations.core.catalog.Catalog;
import ac.simons.neo4j.migrations.core.catalog.CatalogToCypherRenderer;
import ac.simons.neo4j.migrations.core.catalog.CatalogToXMLRenderer;
import ac.simons.neo4j.migrations.core.catalog.Constraint;
import ac.simons.neo4j.migrations.core.catalog.ConstraintToCypherRenderer;
import ac.simons.neo4j.migrations.core.catalog.ConstraintToXMLRenderer;
import ac.simons.neo4j.migrations.core.catalog.Index;
import ac.simons.neo4j.migrations.core.catalog.IndexToCypherRenderer;
import ac.simons.neo4j.migrations.core.catalog.IndexToXMLRenderer;
import ac.simons.neo4j.migrations.core.catalog.RenderConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public interface Renderer<T> {
    public static <T> Renderer<T> get(Format format, T type) {
        return Renderer.get(format, type.getClass());
    }

    public static <T> Renderer<T> get(Format format, Class<T> type) {
        if (format == Format.CYPHER) {
            if (Constraint.class.isAssignableFrom(type)) {
                return ConstraintToCypherRenderer.INSTANCE;
            }
            if (Index.class.isAssignableFrom(type)) {
                return IndexToCypherRenderer.INSTANCE;
            }
            if (Catalog.class.isAssignableFrom(type)) {
                return CatalogToCypherRenderer.INSTANCE;
            }
        } else if (format == Format.XML) {
            if (Constraint.class.isAssignableFrom(type)) {
                return ConstraintToXMLRenderer.INSTANCE;
            }
            if (Index.class.isAssignableFrom(type)) {
                return IndexToXMLRenderer.INSTANCE;
            }
            if (Catalog.class.isAssignableFrom(type)) {
                return CatalogToXMLRenderer.INSTANCE;
            }
        }
        throw new UnsupportedOperationException("Unsupported combination of format (" + format + ") and type (" + type + ").");
    }

    public void render(T var1, RenderConfig var2, OutputStream var3) throws IOException;

    default public String render(T item, RenderConfig config) {
        String string;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.render(item, config, bout);
            bout.flush();
            string = bout.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bout.close();
        return string;
    }

    public static enum Format {
        CYPHER,
        XML;

    }
}

