/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.neo4j.migrations.core.refactorings;

import ac.simons.neo4j.migrations.core.refactorings.Counters;
import ac.simons.neo4j.migrations.core.refactorings.DefaultCounters;
import ac.simons.neo4j.migrations.core.refactorings.Merge;
import ac.simons.neo4j.migrations.core.refactorings.QueryRunner;
import ac.simons.neo4j.migrations.core.refactorings.RefactoringContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Relationship;

final class DefaultMerge
implements Merge {
    private final String query;
    private final List<Merge.PropertyMergePolicy> mergePolicies;

    DefaultMerge(String query, List<Merge.PropertyMergePolicy> mergePolicies) {
        this.query = query;
        this.mergePolicies = mergePolicies;
    }

    @Override
    public Counters apply(RefactoringContext context) {
        try (QueryRunner tx = context.getQueryRunner(QueryRunner.defaultFeatureSet().withElementIdSupport(true));){
            String element = context.findSingleResultIdentifier(this.query).orElseThrow(IllegalArgumentException::new);
            Ids ids = Ids.of(tx.run(new Query(String.format("CALL { %s } WITH %s RETURN collect(elementId(%2$s)) AS ids", this.query, element))).single().get(0).asList(Value::asString));
            if (ids.size() < 2) {
                Counters counters = Counters.empty();
                return counters;
            }
            Function<Query, Counters> runAndConsume = q -> new DefaultCounters(tx.run((Query)q).consume().counters());
            ArrayList results = new ArrayList(4);
            DefaultMerge.generateLabelCopyQuery(context::sanitizeSchemaName, tx, ids).map(runAndConsume).ifPresent(results::add);
            DefaultMerge.generatePropertyCopyQuery(tx, ids, this.mergePolicies).map(runAndConsume).ifPresent(results::add);
            DefaultMerge.generateRelationshipCopyQuery(context::sanitizeSchemaName, tx, ids).map(runAndConsume).ifPresent(results::add);
            DefaultMerge.generateNodeDeletion(ids).map(runAndConsume).ifPresent(results::add);
            Counters counters = results.stream().reduce(Counters.empty(), Counters::add);
            return counters;
        }
    }

    private static Optional<Query> generateLabelCopyQuery(UnaryOperator<String> sanitizer, QueryRunner queryRunner, Ids ids) {
        String queryForLabels = "MATCH (n) WHERE elementId(n) IN $ids\nUNWIND labels(n) AS label\nWITH DISTINCT label\nORDER BY label ASC\nRETURN collect(label) AS labels";
        List labels = queryRunner.run(new Query(queryForLabels, Collections.singletonMap("ids", ids.tail))).single().get("labels").asList(Value::asString);
        if (labels.isEmpty()) {
            return Optional.empty();
        }
        String literals = labels.stream().map(sanitizer).collect(Collectors.joining(":", ":", ""));
        return Optional.of(new Query(String.format("MATCH (n) WHERE elementId(n) = $id SET n%s", literals), Collections.singletonMap("id", ids.first)));
    }

    private static Optional<Query> generatePropertyCopyQuery(QueryRunner queryRunner, Ids ids, List<Merge.PropertyMergePolicy> policies) {
        String queryForProperties = "UNWIND $ids AS id\nMATCH (n) WHERE elementId(n) = id\nUNWIND keys(n) AS key\nWITH key, n[key] as value\n WITH key, collect(value) AS values\nRETURN {key: key, values: values} AS property\nORDER BY property.key ASC";
        List rows = queryRunner.run(new Query(queryForProperties, Collections.singletonMap("ids", ids.value))).list(MapAccessor::asMap);
        if (rows.isEmpty()) {
            return Optional.empty();
        }
        LinkedHashMap<String, Object> combinedProperties = new LinkedHashMap<String, Object>(rows.size());
        for (Map row : rows) {
            for (Map.Entry entry : row.entrySet()) {
                Map property = (Map)entry.getValue();
                String propertyName = (String)property.get("key");
                List aggregatedPropertyValues = (List)property.get("values");
                Object value = DefaultMerge.findPolicy(policies, propertyName).orElseThrow(() -> new IllegalStateException(String.format("Could not find merge policy for node property `%s`", propertyName))).apply(aggregatedPropertyValues);
                combinedProperties.put(propertyName, value);
            }
        }
        return Optional.of(new Query("MATCH (n) WHERE elementId(n) = $id SET n = $properties", Values.parameters((Object[])new Object[]{"id", ids.first, "properties", combinedProperties})));
    }

    private static Optional<Query> generateRelationshipCopyQuery(UnaryOperator<String> sanitizer, QueryRunner queryRunner, Ids ids) {
        String queryForRels = "MATCH (n) WHERE elementId(n) IN $ids\nWITH [ (n)-[r]-() | r ] AS rels\nUNWIND rels AS rel\nRETURN DISTINCT rel, elementId(startNode(rel)) as startId, elementId(endNode(rel)) as endId\nORDER BY type(rel) ASC, elementId(rel) ASC";
        List rows = queryRunner.run(new Query(queryForRels, Collections.singletonMap("ids", ids.tail))).list();
        if (rows.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder query = new StringBuilder("MATCH (target) WHERE elementId(target) = $0 ");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        int parameterIndex = 0;
        parameters.put(String.valueOf(parameterIndex++), ids.first);
        ++parameterIndex;
        for (Record row : rows) {
            Relationship relation = row.get("rel").asRelationship();
            parameters.put(String.valueOf(parameterIndex), relation.asMap());
            String startId = row.get("startId").asString();
            String endId = row.get("endId").asString();
            String relationshipType = (String)sanitizer.apply(relation.type());
            if (ids.tail.contains(startId) && ids.tail.contains(endId)) {
                query.append(String.format("WITH target CREATE (target)-[rel_%1$d:%2$s]->(target) SET rel_%1$d = $%3$d ", parameterIndex, relationshipType, parameterIndex));
                ++parameterIndex;
                continue;
            }
            if (ids.tail.contains(endId)) {
                parameters.put(String.valueOf(parameterIndex + 1), startId);
                query.append(String.format("WITH target MATCH (n_%1$d) WHERE elementId(n_%1$d) = $%1$d ", parameterIndex + 1));
                query.append(String.format("CREATE (n_%1$d)-[rel_%1$d:%2$s]->(target) SET rel_%1$d = $%3$d ", parameterIndex + 1, relationshipType, parameterIndex));
            } else {
                parameters.put(String.valueOf(parameterIndex + 1), endId);
                query.append(String.format("WITH target MATCH (n_%1$d) WHERE elementId(n_%1$d) = $%1$d ", parameterIndex + 1));
                query.append(String.format("CREATE (n_%1$d)<-[rel_%1$d:%2$s]-(target) SET rel_%1$d = $%3$d ", parameterIndex + 1, relationshipType, parameterIndex));
            }
            parameterIndex += 2;
        }
        return Optional.of(new Query(query.toString(), parameters));
    }

    private static Optional<Query> generateNodeDeletion(Ids ids) {
        return Optional.of(new Query("MATCH (n) WHERE elementId(n) IN $ids DETACH DELETE n", Collections.singletonMap("ids", ids.tail)));
    }

    private static Optional<Merge.PropertyMergePolicy> findPolicy(List<Merge.PropertyMergePolicy> policies, String propertyName) {
        return policies.stream().filter(policy -> policy.pattern().matcher(propertyName).matches()).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMerge that = (DefaultMerge)o;
        return this.query.equals(that.query) && this.mergePolicies.equals(that.mergePolicies);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.mergePolicies);
    }

    private record Ids(List<String> value, String first, List<String> tail) {
        static Ids of(List<String> ids) {
            if (ids.isEmpty()) {
                return new Ids(Collections.emptyList(), null, Collections.emptyList());
            }
            return new Ids(ids, ids.get(0), ids.size() == 1 ? Collections.emptyList() : ids.subList(1, ids.size()));
        }

        int size() {
            return this.value.size();
        }
    }
}

