/*
 * Decompiled with CFR 0.152.
 */
package ac.simons.spring.boot.wro4j.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Pattern;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public class RemoveSourceMapsProcessor
implements ResourcePreProcessor {
    public static final Pattern SOURCE_MAP_PATTERN = Pattern.compile("^/(?:\\*|/)?(?:#|@) sourceMappingURL=.+(?:\\s+\\*/)?$");

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);
             BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (SOURCE_MAP_PATTERN.matcher(line).matches()) continue;
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
    }
}

