/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vmf.runtime.core.internal;

import eu.mihosoft.vcollections.VList;
import eu.mihosoft.vcollections.VListChange;
import eu.mihosoft.vcollections.VMappedList;
import eu.mihosoft.vmf.runtime.core.Change;
import eu.mihosoft.vmf.runtime.core.ChangeListener;
import eu.mihosoft.vmf.runtime.core.Changes;
import eu.mihosoft.vmf.runtime.core.ModelVersion;
import eu.mihosoft.vmf.runtime.core.Transaction;
import eu.mihosoft.vmf.runtime.core.VIterator;
import eu.mihosoft.vmf.runtime.core.VObject;
import eu.mihosoft.vmf.runtime.core.internal.ListChangeImpl;
import eu.mihosoft.vmf.runtime.core.internal.ModelVersionImpl;
import eu.mihosoft.vmf.runtime.core.internal.PropChangeImpl;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternal;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import vjavax.observer.Subscription;
import vjavax.observer.collection.CollectionChangeEvent;

@Deprecated
public class ChangesImpl
implements Changes {
    private final VList<ChangeListener> changeListeners = VList.newInstance(new ArrayList());
    private final VList<ChangeListener> nonRecursiveChangeListeners = VList.newInstance(new ArrayList());
    private final VList<Change> all = VList.newInstance(new ArrayList());
    private final VList<Change> unmodifiableAll = VMappedList.newInstance(this.all, e -> e, e -> {
        throw new UnsupportedOperationException("List modification not supported!");
    });
    private final VList<Transaction> transactions = VList.newInstance(new ArrayList());
    private final VList<Transaction> unmodifiableTransactions = VMappedList.newInstance(this.transactions, e -> e, e -> {
        throw new UnsupportedOperationException("List modification not supported!");
    });
    private int currentTransactionStartIndex = 0;
    private VObject model;
    private final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private final List<Subscription> nonRecursiveSubscriptions = new ArrayList<Subscription>();
    private final Map<Object, Subscription> listSubscriptions = new IdentityHashMap<Object, Subscription>();
    private final Map<Object, Subscription> nonRecursiveListSubscriptions = new IdentityHashMap<Object, Subscription>();
    private final PropertyChangeListener objListener;
    private final PropertyChangeListener nonRecursiveObjListener;
    private boolean modelVersioningEnabled;
    private Subscription modelVersioningSubscription;
    private boolean recording;
    private long timestamp;
    private final AtomicLong modelVersionNumber = new AtomicLong(0L);
    private ModelVersion modelVersion = new ModelVersionImpl(System.currentTimeMillis(), 0L);

    public ChangesImpl() {
        this.objListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropChangeImpl c = new PropChangeImpl((VObject)evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                ChangesImpl.this.fireChange(c);
                if (evt.getNewValue() instanceof VObject) {
                    VObject newObjectToObserve = (VObject)evt.getNewValue();
                    ChangesImpl.this.registerChangeListener(newObjectToObserve, this);
                }
                if (evt.getOldValue() instanceof VObject) {
                    VObject objectToRemoveFromObservation = (VObject)evt.getOldValue();
                    ChangesImpl.this.unregisterChangeListener(objectToRemoveFromObservation, this);
                }
            }
        };
        this.changeListeners.addChangeListener(evt -> {
            if (this.changeListeners.isEmpty() && !this.recording) {
                this.unregisterChangeListener(this.model, this.objListener);
            } else if (!this.changeListeners.isEmpty()) {
                this.registerChangeListener(this.model, this.objListener);
            }
        });
        this.nonRecursiveObjListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropChangeImpl c = new PropChangeImpl((VObject)evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                ChangesImpl.this.fireChangeForNonRecursive(c);
            }
        };
        this.nonRecursiveChangeListeners.addChangeListener(evt -> {
            if (this.nonRecursiveChangeListeners.isEmpty() && !this.recording) {
                this.unregisterChangeListenerNonRecursive(this.model, this.nonRecursiveObjListener);
                this.nonRecursiveSubscriptions.forEach(s -> s.unsubscribe());
            } else if (!this.nonRecursiveChangeListeners.isEmpty()) {
                this.registerChangeListenerNonRecursive(this.model, this.nonRecursiveObjListener);
            }
        });
    }

    private void fireChange(Change c) {
        for (ChangeListener cl : this.changeListeners) {
            cl.onChange(c);
        }
        if (this.recording && this.nonRecursiveChangeListeners.isEmpty()) {
            this.all.add((Object)c);
        }
    }

    private void fireChangeForNonRecursive(Change c) {
        for (ChangeListener cl : this.nonRecursiveChangeListeners) {
            cl.onChange(c);
        }
        if (this.recording && this.changeListeners.isEmpty()) {
            this.all.add((Object)c);
        }
    }

    public void setModel(VObject model) {
        this.model = model;
    }

    @Override
    public void start() {
        this.clear();
        this.recording = true;
        this.registerChangeListener(this.model, this.objListener);
        this.enableModelVersioning();
    }

    private void registerChangeListener(VObject vObj, PropertyChangeListener objListener) {
        VIterator it = vObj.vmf().content().iterator(VIterator.IterationStrategy.UNIQUE_NODE);
        while (it.hasNext()) {
            VObjectInternal obj = (VObjectInternal)it.next();
            this.removeListListenersFromPropertiesOf(obj, objListener);
            this.addListListenersToPropertiesOf(obj, objListener);
            obj.removePropertyChangeListener(objListener);
            obj.addPropertyChangeListener(objListener);
            this.subscriptions.add(() -> obj.removePropertyChangeListener(objListener));
        }
    }

    private void unregisterChangeListener(VObject vObj, PropertyChangeListener objListener) {
        VIterator it = vObj.vmf().content().iterator(VIterator.IterationStrategy.UNIQUE_NODE);
        while (it.hasNext()) {
            VObjectInternal obj = (VObjectInternal)it.next();
            this.removeListListenersFromPropertiesOf(obj, objListener);
            obj.removePropertyChangeListener(objListener);
        }
    }

    private void registerChangeListenerNonRecursive(VObject vObj, PropertyChangeListener objListener) {
        this.addNonRecursiveListListeners(vObj, objListener);
        VObjectInternal obj = (VObjectInternal)vObj;
        obj.addPropertyChangeListener(objListener);
    }

    private void unregisterChangeListenerNonRecursive(VObject vObj, PropertyChangeListener objListener) {
        this.removeNonRecursiveListListeners(vObj, objListener);
        VObjectInternal obj = (VObjectInternal)vObj;
        obj.removePropertyChangeListener(objListener);
    }

    private void addNonRecursiveListListeners(VObject object, PropertyChangeListener objListener) {
        VObjectInternal internalModel = (VObjectInternal)object;
        for (int i = 0; i < internalModel._vmf_getPropertyTypes().length; ++i) {
            int type = internalModel._vmf_getPropertyTypes()[i];
            if (type != -2) continue;
            String propName = internalModel._vmf_getPropertyNames()[i];
            VList list = (VList)internalModel._vmf_getPropertyValueById(i);
            Subscription subscription = list.addChangeListener(evt -> {
                ListChangeImpl c = new ListChangeImpl(object, propName, (CollectionChangeEvent<Object, VList<Object>, VListChange<Object>>)evt);
                this.fireChangeForNonRecursive(c);
            });
            this.nonRecursiveSubscriptions.add(subscription);
            this.nonRecursiveListSubscriptions.put(list, subscription);
        }
    }

    private void addListListenersToPropertiesOf(VObject object, PropertyChangeListener objListener) {
        VObjectInternal internalModel = (VObjectInternal)object;
        for (int i = 0; i < internalModel._vmf_getPropertyTypes().length; ++i) {
            int type = internalModel._vmf_getPropertyTypes()[i];
            if (type != -2) continue;
            String propName = internalModel._vmf_getPropertyNames()[i];
            VList list = (VList)internalModel._vmf_getPropertyValueById(i);
            Subscription subscription = list.addChangeListener(evt -> {
                ListChangeImpl c = new ListChangeImpl(object, propName, (CollectionChangeEvent<Object, VList<Object>, VListChange<Object>>)evt);
                this.fireChange(c);
                ((VListChange)evt.added()).elements().stream().filter(e -> e instanceof VObjectInternal).map(e -> (VObjectInternal)e).forEach(v -> {
                    v.removePropertyChangeListener(objListener);
                    this.registerChangeListener((VObject)v, objListener);
                    this.subscriptions.add(() -> v.removePropertyChangeListener(objListener));
                });
                ((VListChange)evt.removed()).elements().stream().filter(e -> e instanceof VObject).map(e -> (VObject)e).forEach(v -> this.unregisterChangeListener((VObject)v, objListener));
            });
            this.subscriptions.add(subscription);
            this.listSubscriptions.put(list, subscription);
        }
    }

    private void removeListListenersFromPropertiesOf(VObject object, PropertyChangeListener objListener) {
        VObjectInternal internalModel = (VObjectInternal)object;
        for (int i = 0; i < internalModel._vmf_getPropertyTypes().length; ++i) {
            int type = internalModel._vmf_getPropertyTypes()[i];
            if (type != -2) continue;
            String propName = internalModel._vmf_getPropertyNames()[i];
            VList list = (VList)internalModel._vmf_getPropertyValueById(i);
            if (!this.listSubscriptions.containsKey(list)) continue;
            this.listSubscriptions.get(list).unsubscribe();
        }
    }

    private void removeNonRecursiveListListeners(VObject object, PropertyChangeListener objListener) {
        VObjectInternal internalModel = (VObjectInternal)object;
        for (int i = 0; i < internalModel._vmf_getPropertyTypes().length; ++i) {
            VList list;
            int type = internalModel._vmf_getPropertyTypes()[i];
            if (type != -2 || !this.nonRecursiveListSubscriptions.containsKey(list = (VList)internalModel._vmf_getPropertyValueById(i))) continue;
            this.nonRecursiveListSubscriptions.get(list).unsubscribe();
        }
    }

    @Override
    public void startTransaction() {
        if (!this.recording) {
            throw new RuntimeException("Please call 'start()' before starting a transaction.");
        }
        this.currentTransactionStartIndex = this.all.size();
    }

    @Override
    public void publishTransaction() {
        if (this.currentTransactionStartIndex < this.unmodifiableAll.size()) {
            this.transactions.add((Object)new TransactionImpl(this.unmodifiableAll.subList(this.currentTransactionStartIndex, this.all.size())));
            this.currentTransactionStartIndex = this.unmodifiableAll.size();
        }
    }

    @Override
    public void stop() {
        if (this.currentTransactionStartIndex < this.all.size()) {
            this.publishTransaction();
        }
        this.subscriptions.forEach(s -> s.unsubscribe());
        this.subscriptions.clear();
        this.recording = false;
        this.unregisterChangeListener(this.model, this.objListener);
        this.disableModelVersioning();
    }

    @Override
    public VList<Change> all() {
        return this.unmodifiableAll;
    }

    @Override
    public VList<Transaction> transactions() {
        return this.unmodifiableTransactions;
    }

    @Override
    public void clear() {
        this.all.clear();
        this.transactions.clear();
    }

    @Override
    public Subscription addListener(ChangeListener l) {
        this.changeListeners.add((Object)l);
        return () -> this.changeListeners.remove((Object)l);
    }

    @Override
    public Subscription addListener(ChangeListener l, boolean recursive) {
        if (recursive) {
            return this.addListener(l);
        }
        this.nonRecursiveChangeListeners.add((Object)l);
        return () -> this.nonRecursiveChangeListeners.remove((Object)l);
    }

    @Override
    public ModelVersion modelVersion() {
        return this.modelVersion;
    }

    public void enableModelVersioning() {
        if (this.modelVersioningSubscription != null) {
            this.modelVersioningSubscription.unsubscribe();
            this.modelVersioningSubscription = null;
        }
        this.modelVersioningSubscription = this.addListener(change -> {
            this.timestamp = change.getTimestamp();
            this.modelVersionNumber.getAndIncrement();
            this.modelVersion = new ModelVersionImpl(this.timestamp, this.modelVersionNumber.get());
        });
        this.modelVersioningEnabled = true;
    }

    public void disableModelVersioning() {
        if (this.recording) {
            throw new RuntimeException("Cannot disable model versioning during change recording. Call stop() before disabling model versioning.");
        }
        if (this.modelVersioningSubscription != null) {
            this.modelVersioningSubscription.unsubscribe();
            this.modelVersioningSubscription = null;
        }
        this.modelVersioningEnabled = false;
    }

    @Override
    public boolean isModelVersioningEnabled() {
        return this.modelVersioningEnabled;
    }

    static class TransactionImpl
    implements Transaction {
        private final List<Change> changes;

        public TransactionImpl(List<Change> changes) {
            this.changes = changes;
        }

        @Override
        public List<Change> changes() {
            return this.changes;
        }

        @Override
        public boolean isUndoable() {
            for (Change c : this.changes) {
                if (c.isUndoable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void undo() {
            for (int i = this.changes.size() - 1; i > -1; --i) {
                this.changes.get(i).undo();
            }
        }
    }
}

