/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vmf.runtime.core;

import eu.mihosoft.vmf.runtime.core.Annotation;
import eu.mihosoft.vmf.runtime.core.ChangeListener;
import eu.mihosoft.vmf.runtime.core.Type;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternal;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternalModifiable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import vjavax.observer.Subscription;

public final class Property {
    private final VObjectInternal parent;
    private final int propertyId;
    private final String name;
    private Type type;
    private boolean staticOnly;
    private static Map<String, Class<?>> primitives = new HashMap();

    static boolean isPrimitiveType(String clsName) {
        return primitives.containsKey(clsName);
    }

    private Class<?> getClassObjectByName(String clsName) {
        Class<?> result = primitives.get(clsName);
        if (result == null) {
            try {
                result = this.parent.getClass().getClassLoader().loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Property(VObjectInternal parent, String name, boolean staticOnly) {
        boolean isListType;
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("byte", Byte.TYPE);
        this.parent = parent;
        this.name = name;
        this.staticOnly = staticOnly;
        this.propertyId = parent._vmf_getPropertyIdByName(name);
        boolean isModelType = parent._vmf_getPropertyTypes()[this.propertyId] != -1;
        boolean bl = isListType = parent._vmf_getPropertyTypes()[this.propertyId] == -2;
        if (isListType) {
            isModelType = false;
            for (int pId : parent._vmf_getIndicesOfPropertiesWithModelElementTypes()) {
                if (this.propertyId != pId) continue;
                isModelType = true;
                break;
            }
        }
        String typeName = parent._vmf_getPropertyTypeNames()[this.propertyId];
        try {
            this.type = isListType ? Type.newInstance(isModelType, isListType, typeName, parent.getClass().getClassLoader().loadClass("eu.mihosoft.vcollections.VList")) : (Property.isPrimitiveType(typeName) ? Type.newInstance(isModelType, isListType, typeName, this.getClassObjectByName(typeName)) : Type.newInstance(isModelType, isListType, typeName, parent.getClass().getClassLoader().loadClass(typeName)));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static Property newInstance(VObjectInternal parent, String name, boolean staticOnly) {
        return new Property(parent, name, staticOnly);
    }

    public boolean isSet() {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot check if property is set without access to an instance.");
        }
        return this.parent._vmf_isSetById(this.propertyId);
    }

    public void set(Object o) {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot set property without access to an instance.");
        }
        if (!(this.parent instanceof VObjectInternalModifiable)) {
            throw new RuntimeException("Cannot modify unmodifiable object");
        }
        ((VObjectInternalModifiable)this.parent)._vmf_setPropertyValueById(this.propertyId, o);
    }

    public void unset() {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot set property without access to an instance.");
        }
        if (!(this.parent instanceof VObjectInternalModifiable)) {
            throw new RuntimeException("Cannot modify unmodifiable object");
        }
        ((VObjectInternalModifiable)this.parent)._vmf_setPropertyValueById(this.propertyId, this.getDefault());
    }

    public Object get() {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot get property without access to an instance.");
        }
        return this.parent._vmf_getPropertyValueById(this.propertyId);
    }

    @Deprecated
    public void setDefault(Object value) {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot set property without access to an instance.");
        }
        if (!(this.parent instanceof VObjectInternalModifiable)) {
            throw new RuntimeException("Cannot modify unmodifiable object");
        }
        ((VObjectInternalModifiable)this.parent)._vmf_setDefaultValueById(this.propertyId, value);
    }

    public Object getDefault() {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot set property without access to an instance.");
        }
        return this.parent._vmf_getDefaultValueById(this.propertyId);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<Annotation> annotations() {
        return this.parent._vmf_getPropertyAnnotationsById(this.propertyId);
    }

    public Optional<Annotation> annotationByKey(String key) {
        return this.annotations().stream().filter(a -> key.equals(a.getKey())).findFirst();
    }

    public Subscription addChangeListener(ChangeListener l) {
        if (this.parent == null || this.staticOnly) {
            throw new RuntimeException("Cannot add change listeners without access to an instance.");
        }
        Subscription s = this.parent.vmf().changes().addListener(c -> {
            if (Objects.equals(this.getName(), c.propertyName())) {
                l.onChange(c);
            }
        }, false);
        return s;
    }
}

