/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vmf.runtime.core;

import eu.mihosoft.vmf.runtime.core.Reflect;
import eu.mihosoft.vmf.runtime.core.VObject;
import eu.mihosoft.vmf.runtime.core.internal.ReflectImpl;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Type {
    private final boolean modelType;
    private final boolean listType;
    private final String name;
    private final Class<?> modelClass;
    private List<Type> superTypes;
    private VObject prototype;

    private Type(boolean modelType, boolean listType, String name, Class<?> modelClass) {
        this.modelType = modelType;
        this.listType = listType;
        this.name = name;
        this.modelClass = modelClass;
    }

    @Deprecated
    public static Type newInstance(boolean modelType, boolean listType, String name, Class<?> modelClass) {
        return new Type(modelType, listType, name, modelClass);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getElementTypeName() {
        if (!this.isListType()) {
            return Optional.empty();
        }
        String tName = this.getName();
        int firstIdx = tName.indexOf(60);
        if (firstIdx < 1) {
            return Optional.empty();
        }
        int lastIdx = tName.lastIndexOf(62);
        if (lastIdx <= firstIdx) {
            return Optional.empty();
        }
        return Optional.of(tName.substring(firstIdx + 1, lastIdx));
    }

    public boolean isModelType() {
        return this.modelType;
    }

    public boolean isListType() {
        return this.listType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)o;
        return this.modelType == type.modelType && this.listType == type.listType && Objects.equals(this.name, type.name);
    }

    public int hashCode() {
        return Objects.hash(this.modelType, this.listType, this.name);
    }

    public String toString() {
        return "[ name=" + this.name + ", modelType=" + this.modelType + ", listType=" + this.listType + ", cls: " + this.modelClass + " ]";
    }

    public Reflect reflect() {
        ReflectImpl reflect = (ReflectImpl)this.getPrototype().vmf().reflect();
        reflect.setStaticOnly(true);
        return reflect;
    }

    private VObject getPrototype() {
        if (!this.isModelType()) {
            throw new RuntimeException("Cannot initialize reflection API of type type '" + this.modelClass.getTypeName() + "'. Reflection failed.");
        }
        if (this.prototype == null) {
            try {
                Method method = this.modelClass.getMethod("newInstance", new Class[0]);
                this.prototype = (VObject)method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        return this.prototype;
    }

    public List<Type> superTypes() {
        if (this.superTypes == null) {
            this.superTypes = new ArrayList<Type>();
            if (this.isModelType() && !this.isListType()) {
                String[] superTypeNames;
                VObjectInternal parent = (VObjectInternal)this.getPrototype();
                for (String tName : superTypeNames = parent._vmf_getSuperTypeNames()) {
                    try {
                        this.superTypes.add(Type.newInstance(true, false, tName, Class.forName(tName)));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new RuntimeException("Cannot load super type class of type '" + tName + "'. Reflection failed.");
                    }
                }
            }
        }
        return this.superTypes;
    }
}

