/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vmf.runtime.core;

import eu.mihosoft.vmf.runtime.core.Immutable;
import eu.mihosoft.vmf.runtime.core.TraversalListener;
import eu.mihosoft.vmf.runtime.core.VIterator;
import eu.mihosoft.vmf.runtime.core.VMFPropertyIterator;
import eu.mihosoft.vmf.runtime.core.VObject;
import eu.mihosoft.vmf.runtime.core.VObjectIterator;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternal;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Stack;

class VMFIterator
implements Iterator<VObjectInternal> {
    private final IdentityHashMap<Object, Object> identityMap = new IdentityHashMap();
    private VObjectInternal first;
    private VObjectIterator currentIterator;
    private VObjectIterator prevIterator;
    private boolean usedCurrentIterator;
    private final Stack<VObjectIterator> iteratorStack = new Stack();
    private final TraversalListener traversalListener;
    private final VIterator.IterationStrategy strategy;
    private static boolean DEBUG;

    static boolean isDebug() {
        return DEBUG;
    }

    public VMFIterator(VObjectInternal root, TraversalListener tl, VIterator.IterationStrategy strategy) {
        this.first = root;
        this.traversalListener = tl;
        this.currentIterator = new VMFPropertyIterator(this.identityMap, root, strategy);
        this.strategy = strategy;
    }

    @Override
    public boolean hasNext() {
        if (this.first != null) {
            return true;
        }
        return this.getCurrentIterator().hasNext();
    }

    @Override
    public VObjectInternal next() {
        VObjectInternal n;
        if (this.first != null) {
            n = this.first;
            if (!(this.first instanceof Immutable)) {
                this.identityMap.put(n, null);
            }
            this.first = null;
            this.onEnter(n);
        } else {
            n = (VObjectInternal)this.getCurrentIterator().next();
            Object nIdentityObj = VMFIterator.unwrapIfReadOnlyInstanceForIdentityCheck(n);
            if (!this.identityMap.containsKey(nIdentityObj)) {
                if (!(nIdentityObj instanceof Immutable)) {
                    this.identityMap.put(nIdentityObj, null);
                }
                this.iteratorStack.push(this.currentIterator);
                this.prevIterator = this.currentIterator;
                this.onEnter(n);
                this.currentIterator = new VMFPropertyIterator(this.identityMap, n, this.strategy);
                this.usedCurrentIterator = false;
            }
        }
        return n;
    }

    static Object unwrapIfReadOnlyInstanceForIdentityCheck(Object o) {
        if (o instanceof Immutable) {
            return o;
        }
        if (!(o instanceof VObjectInternal)) {
            return o;
        }
        VObjectInternal n = (VObjectInternal)o;
        VObject nIdentityObj = n._vmf_isReadOnly() ? n._vmf_getMutableObject() : n;
        return nIdentityObj;
    }

    @Override
    public void remove() {
        if (this.first != null) {
            throw new RuntimeException("Cannot remove first object (root) of this object tree");
        }
        if (this.usedCurrentIterator) {
            this.getCurrentIterator().remove();
        } else if (this.prevIterator != null) {
            this.prevIterator.remove();
        } else {
            throw new RuntimeException("Cannot remove element (please submit a bug report)");
        }
    }

    public void set(VObject o) {
        if (this.first != null) {
            throw new RuntimeException("Cannot replace first object (root) of this object tree");
        }
        if (this.usedCurrentIterator) {
            this.getCurrentIterator().set(o);
        } else if (this.prevIterator != null) {
            this.prevIterator.set(o);
        } else {
            throw new RuntimeException("Cannot replace element (please submit a bug report)");
        }
    }

    public void add(VObject o) {
        if (this.first != null) {
            throw new RuntimeException("Cannot add object to the first object (root) of this object tree");
        }
        if (this.usedCurrentIterator) {
            this.getCurrentIterator().add(o);
        } else if (this.prevIterator != null) {
            this.prevIterator.add(o);
        } else {
            throw new RuntimeException("Cannot add element (please submit a bug report)");
        }
    }

    boolean isAddSupported() {
        if (this.usedCurrentIterator) {
            return this.getCurrentIterator().isAddSupported();
        }
        if (this.prevIterator != null) {
            return this.prevIterator.isAddSupported();
        }
        return false;
    }

    private VObjectIterator getCurrentIterator() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            if (VMFIterator.isDebug()) {
                System.out.println(" --> leaving current + " + this.currentIterator.object());
            }
            this.onExit(this.currentIterator.object());
            this.currentIterator = !this.iteratorStack.empty() ? this.iteratorStack.pop() : VObjectIterator.EMTPY_ITERATOR;
            if (!this.currentIterator.hasNext() && !this.iteratorStack.isEmpty()) {
                this.currentIterator = this.getCurrentIterator();
            }
        }
        return this.currentIterator;
    }

    void onEnter(VObject o) {
        if (this.traversalListener == null || this.traversalListener.isIgnoreNullObjects() && o == null) {
            return;
        }
        this.traversalListener.onEnter(o);
    }

    void onExit(VObject o) {
        if (this.traversalListener == null || this.traversalListener.isIgnoreNullObjects() && o == null) {
            return;
        }
        this.traversalListener.onExit(o);
    }
}

