/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vmf.runtime.core;

import eu.mihosoft.vcollections.VList;
import eu.mihosoft.vmf.runtime.core.VIterator;
import eu.mihosoft.vmf.runtime.core.VMFIterator;
import eu.mihosoft.vmf.runtime.core.VObject;
import eu.mihosoft.vmf.runtime.core.VObjectIterator;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternal;
import eu.mihosoft.vmf.runtime.core.internal.VObjectInternalModifiable;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.function.Predicate;

class VMFPropertyIterator
implements VObjectIterator {
    private final VObjectInternal object;
    private int index = -1;
    private ListIterator<VObject> listIterator;
    private final IdentityHashMap<Object, Object> identityMap;
    private final VIterator.IterationStrategy strategy;

    public VMFPropertyIterator(IdentityHashMap<Object, Object> identityMap, VObjectInternal object, VIterator.IterationStrategy strategy) {
        this.identityMap = identityMap;
        this.object = object;
        this.strategy = strategy;
        if (VMFIterator.isDebug()) {
            int numProps = object._vmf_getIndicesOfPropertiesWithModelTypeOrElementTypes().length;
            System.out.println(">> prop iterator for " + object.getClass());
            for (int i = 0; i < numProps; ++i) {
                int propIndex = object._vmf_getIndicesOfPropertiesWithModelTypeOrElementTypes()[i];
                System.out.println("  --> i: " + i + ", name: " + object._vmf_getPropertyNames()[propIndex]);
            }
            if (numProps == 0) {
                System.out.println("  --> no props");
            }
        }
    }

    @Override
    public boolean hasNext() {
        int[] properties;
        int numProperties;
        boolean hasNext;
        if (VMFIterator.isDebug()) {
            System.out.println(" --> checking " + this.index);
        }
        if (this.listIterator != null) {
            hasNext = this.hasNextListElement();
            if (hasNext) {
                return true;
            }
            this.listIterator = null;
            if (VMFIterator.isDebug()) {
                System.out.println("  --> leaving list, next is " + (this.index + 1));
            }
        }
        boolean bl = hasNext = this.index + 1 < (numProperties = (properties = this.getPropIndices()).length);
        if (hasNext) {
            int nextIndex = this.index + 1;
            int propIndex = properties[nextIndex];
            Object o = this.object._vmf_getPropertyValueById(propIndex);
            if (o == null && this.index + 2 < numProperties) {
                ++this.index;
                hasNext = this.hasNext();
            } else if (o == null) {
                return false;
            }
            if (o instanceof VList) {
                boolean hasNonEmpty;
                Predicate<Object> hasNextFilter = this.strategy == VIterator.IterationStrategy.UNIQUE_NODE ? e -> !this.identityMap.containsKey(VMFIterator.unwrapIfReadOnlyInstanceForIdentityCheck(e)) : e -> true;
                boolean bl2 = hasNonEmpty = ((VList)o).stream().filter(e -> e != null).filter(hasNextFilter).count() > 0L;
                if (!hasNonEmpty && this.index + 2 < numProperties) {
                    ++this.index;
                    hasNext = this.hasNext();
                    return hasNext;
                }
                hasNext = hasNonEmpty;
            }
            if (this.strategy == VIterator.IterationStrategy.UNIQUE_NODE) {
                boolean alreadyVisited = this.identityMap.containsKey(VMFIterator.unwrapIfReadOnlyInstanceForIdentityCheck(o));
                if (alreadyVisited && this.index + 2 < numProperties) {
                    ++this.index;
                    hasNext = this.hasNext();
                } else if (alreadyVisited) {
                    hasNext = false;
                }
            }
        }
        return hasNext;
    }

    @Override
    public VObject next() {
        boolean alreadyVisited;
        int[] properties;
        int propIndex;
        Object o;
        if (this.listIterator != null) {
            if (VMFIterator.isDebug()) {
                System.out.println("  --> using list at " + this.index);
            }
            return this.nextListElement();
        }
        ++this.index;
        if (VMFIterator.isDebug()) {
            System.out.println("  --> returning " + this.index);
        }
        if ((o = this.object._vmf_getPropertyValueById(propIndex = (properties = this.getPropIndices())[this.index])) == null) {
            o = this.next();
        }
        if (o instanceof VList) {
            this.listIterator = ((VList)o).listIterator();
            if (VMFIterator.isDebug()) {
                System.out.println("  --> switching to list at " + this.index);
            }
            o = this.nextListElement();
        }
        if (this.strategy == VIterator.IterationStrategy.UNIQUE_NODE && (alreadyVisited = this.identityMap.containsKey(VMFIterator.unwrapIfReadOnlyInstanceForIdentityCheck(o)))) {
            o = this.next();
        }
        return (VObject)o;
    }

    private VObject nextListElement() {
        VObject o = null;
        Predicate<Object> hasNextFilter = this.strategy == VIterator.IterationStrategy.UNIQUE_NODE ? e -> !this.identityMap.containsKey(VMFIterator.unwrapIfReadOnlyInstanceForIdentityCheck(e)) : e -> true;
        while (this.listIterator.hasNext() && (o == null || !hasNextFilter.test(o))) {
            o = this.listIterator.next();
        }
        return o;
    }

    private boolean hasNextListElement() {
        if (!this.listIterator.hasNext()) {
            return false;
        }
        Predicate<Object> hasNextFilter = this.strategy == VIterator.IterationStrategy.UNIQUE_NODE ? e -> !this.identityMap.containsKey(VMFIterator.unwrapIfReadOnlyInstanceForIdentityCheck(e)) : e -> true;
        VObject o = this.listIterator.next();
        this.listIterator.previous();
        if (o == null) {
            return false;
        }
        return hasNextFilter.test(o);
    }

    private int[] getPropIndices() {
        int[] properties = this.strategy == VIterator.IterationStrategy.CONTAINMENT_TREE ? this.object._vmf_getChildrenIndices() : this.object._vmf_getIndicesOfPropertiesWithModelTypeOrElementTypes();
        return properties;
    }

    @Override
    public void remove() {
        if (this.object._vmf_isReadOnly()) {
            throw new RuntimeException("Cannot modify unmodifiable object!");
        }
        if (this.listIterator != null) {
            this.listIterator.remove();
        } else {
            int[] properties = this.getPropIndices();
            if (this.index < 0) {
                return;
            }
            int propIndex = properties[this.index];
            if (this.object instanceof VObjectInternalModifiable) {
                ((VObjectInternalModifiable)this.object)._vmf_setPropertyValueById(propIndex, null);
            } else {
                throw new RuntimeException("Cannot modify unmodifiable object!");
            }
        }
    }

    @Override
    public void set(VObject o) {
        if (this.object._vmf_isReadOnly()) {
            throw new RuntimeException("Cannot modify unmodifiable object!");
        }
        if (this.listIterator != null) {
            this.listIterator.set(o);
        } else {
            int[] properties = this.getPropIndices();
            if (this.index < 0) {
                return;
            }
            int propIndex = properties[this.index];
            if (this.object instanceof VObjectInternalModifiable) {
                ((VObjectInternalModifiable)this.object)._vmf_setPropertyValueById(propIndex, o);
            } else {
                throw new RuntimeException("Cannot modify unmodifiable object!");
            }
        }
    }

    @Override
    public void add(VObject o) {
        if (this.object._vmf_isReadOnly()) {
            throw new RuntimeException("Cannot modify unmodifiable object!");
        }
        if (this.listIterator == null) {
            throw new RuntimeException("Adding objects to non-list properties is not supported.");
        }
        this.listIterator.add(o);
    }

    @Override
    public boolean isAddSupported() {
        return this.listIterator != null;
    }

    @Override
    public VObject object() {
        return this.object;
    }
}

