/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.Vibrator;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import eu.nets.pia.PiaInterfaceConfiguration;
import eu.nets.pia.R;
import eu.nets.pia.cardio.CameraUnavailableException;
import eu.nets.pia.cardio.CardScanner;
import eu.nets.pia.cardio.CreditCard;
import eu.nets.pia.cardio.DetectionInfo;
import eu.nets.pia.cardio.OverlayView;
import eu.nets.pia.cardio.Preview;
import eu.nets.pia.cardio.Util;
import eu.nets.pia.cardio.ui.CustomToolbar;
import eu.nets.pia.cardio.ui.ViewUtil;
import eu.nets.pia.ui.custom.PiaButton;
import eu.nets.pia.ui.main.PiaActivity;
import eu.nets.pia.ui.themes.PiaTheme;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import k.d;

public final class CardIOActivity
extends Activity {
    public static final String EXTRA_NO_CAMERA = "io.card.payment.noCamera";
    public static final String EXTRA_REQUIRE_EXPIRY = "io.card.payment.requireExpiry";
    public static final String EXTRA_SCAN_EXPIRY = "io.card.payment.scanExpiry";
    public static final String EXTRA_UNBLUR_DIGITS = "io.card.payment.unblurDigits";
    public static final String EXTRA_REQUIRE_CVV = "io.card.payment.requireCVV";
    public static final String EXTRA_REQUIRE_POSTAL_CODE = "io.card.payment.requirePostalCode";
    public static final String EXTRA_RESTRICT_POSTAL_CODE_TO_NUMERIC_ONLY = "io.card.payment.restrictPostalCodeToNumericOnly";
    public static final String EXTRA_REQUIRE_CARDHOLDER_NAME = "io.card.payment.requireCardholderName";
    public static final String EXTRA_USE_CARDIO_LOGO = "io.card.payment.useCardIOLogo";
    public static final String EXTRA_SCAN_RESULT = "io.card.payment.scanResult";
    private static final String EXTRA_MANUAL_ENTRY_RESULT = "io.card.payment.manualEntryScanResult";
    public static final String EXTRA_SUPPRESS_MANUAL_ENTRY = "io.card.payment.suppressManual";
    public static final String EXTRA_LANGUAGE_OR_LOCALE = "io.card.payment.languageOrLocale";
    public static final String EXTRA_GUIDE_COLOR = "io.card.payment.guideColor";
    public static final String EXTRA_SUPPRESS_CONFIRMATION = "io.card.payment.suppressConfirmation";
    public static final String EXTRA_HIDE_CARDIO_LOGO = "io.card.payment.hideLogo";
    public static final String EXTRA_SUPPRESS_SCAN = "io.card.payment.suppressScan";
    public static final String EXTRA_CAPTURED_CARD_IMAGE = "io.card.payment.capturedCardImage";
    public static final String EXTRA_RETURN_CARD_IMAGE = "io.card.payment.returnCardImage";
    public static final String EXTRA_SCAN_OVERLAY_LAYOUT_ID = "io.card.payment.scanOverlayLayoutId";
    public static final String EXTRA_IS_USER_RETURNING = "io.card.payment.isUserReturning";
    public static final String EXTRA_USE_PAYPAL_ACTIONBAR_ICON = "io.card.payment.intentSenderIsPayPal";
    public static final String EXTRA_KEEP_APPLICATION_THEME = "io.card.payment.keepApplicationTheme";
    static final String PRIVATE_EXTRA_CAMERA_BYPASS_TEST_MODE = "io.card.payment.cameraBypassTestMode";
    private static int lastResult;
    public static final int RESULT_CARD_INFO;
    public static final int RESULT_ENTRY_CANCELED;
    public static final int RESULT_SCAN_NOT_AVAILABLE;
    public static final int RESULT_SCAN_SUPPRESSED;
    public static final int RESULT_CANCEL_PROCESS;
    public static final int RESULT_CONFIRMATION_SUPPRESSED;
    private static final String TAG;
    private static final int DEGREE_DELTA = 15;
    private static final int ORIENTATION_PORTRAIT = 1;
    private static final int ORIENTATION_PORTRAIT_UPSIDE_DOWN = 2;
    private static final int ORIENTATION_LANDSCAPE_RIGHT = 3;
    private static final int ORIENTATION_LANDSCAPE_LEFT = 4;
    private static final int FRAME_ID = 1;
    private static final int UIBAR_ID = 2;
    private static final int KEY_BTN_ID = 3;
    private static final String BUNDLE_WAITING_FOR_PERMISSION = "io.card.payment.waitingForPermission";
    private static final float UIBAR_VERTICAL_MARGIN_DP = 15.0f;
    private static final long[] VIBRATE_PATTERN;
    private static final int TOAST_OFFSET_Y = -75;
    private static final int DATA_ENTRY_REQUEST_ID = 10;
    private static final int PERMISSION_REQUEST_ID = 11;
    static Bitmap markedCardImage;
    static final /* synthetic */ boolean $assertionsDisabled;
    private OverlayView mOverlay;
    private OrientationEventListener orientationListener;
    Preview mPreview;
    private CreditCard mDetectedCard;
    private Rect mGuideFrame;
    private int mLastDegrees;
    private int mFrameOrientation;
    private boolean suppressManualEntry;
    private boolean mDetectOnly;
    private LinearLayout customOverlayLayout;
    private boolean waitingForPermission;
    private RelativeLayout mUIBar;
    private FrameLayout mMainLayout;
    private CardScanner mCardScanner;
    private boolean isUserReturning = false;
    private boolean manualEntryFallbackOrForced = false;
    private PiaButton manualEntryButton;
    private CustomToolbar customToolbar;
    int width = 640;
    int height = 480;

    private void showDeniedPermissionDialog() {
        AlertDialog.Builder builder;
        AlertDialog.Builder builder2;
        AlertDialog.Builder builder3;
        AlertDialog.Builder builder4;
        AlertDialog.Builder builder5;
        try {
            AlertDialog.Builder builder6;
            builder5 = builder6;
            builder4 = builder6;
            builder3 = builder6;
            builder2 = builder6;
            builder6 = new AlertDialog.Builder((Context)this);
            builder = builder6;
            builder6.setTitle(R.string.pia_denied_permission_title);
        }
        catch (Exception exception) {}
        builder3.setMessage(R.string.pia_denied_permission_message);
        builder2.setCancelable(false);
        builder5.setPositiveButton(R.string.pia_alert_settings_action, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                1 v0 = this;
                dialogInterface.cancel();
                CardIOActivity.access$002(v0.CardIOActivity.this, false);
                v0.CardIOActivity.this.goToPermissionSettings();
            }
        });
        builder4.setNegativeButton(R.string.pia_alert_ok_action, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
                CardIOActivity.this.setResultAndFinish(RESULT_CONFIRMATION_SUPPRESSED, new Intent());
            }
        });
        builder.create().show();
    }

    private void goToPermissionSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.addFlags(0x10000000);
        intent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
        this.startActivity(intent);
    }

    private void android23AndAboveHandleCamera() {
        if (this.manualEntryFallbackOrForced) {
            this.finishIfSuppressManualEntry();
        } else {
            this.showCameraScannerOverlay();
        }
    }

    private void android22AndBelowHandleCamera() {
        if (this.manualEntryFallbackOrForced) {
            this.finishIfSuppressManualEntry();
        } else {
            this.showCameraScannerOverlay();
        }
    }

    private void finishIfSuppressManualEntry() {
        if (this.suppressManualEntry) {
            this.setResultAndFinish(RESULT_SCAN_NOT_AVAILABLE, null);
        }
    }

    private void checkCamera() {
        block3: {
            if (Util.hardwareSupported()) break block3;
            try {
                this.manualEntryFallbackOrForced = true;
            }
            catch (CameraUnavailableException cameraUnavailableException) {
                Toast toast = Toast.makeText((Context)this, (CharSequence)"Camera unavailable", (int)1);
                toast.setGravity(17, 0, -75);
                toast.show();
                this.manualEntryFallbackOrForced = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void showCameraScannerOverlay() {
        this.mGuideFrame = new Rect();
        this.mFrameOrientation = 1;
        if (!this.getIntent().getBooleanExtra("io.card.payment.cameraBypassTestMode", false)) ** GOTO lbl25
        if (!this.getPackageName().contentEquals("io.card.development")) ** GOTO lbl24
        v0 = this;
        v1 = Class.forName("io.card.payment.CardScannerTester");
        v2 = new Class[2];
        v2[0] = CardIOActivity.class;
        v2[1] = Integer.TYPE;
        v3 = v1.getConstructor(v2);
        v4 = new Object[2];
        v5 = v4;
        v6 = v4;
        v4[0] = this;
        v6[1] = this.mFrameOrientation;
        v0.mCardScanner = (CardScanner)v3.newInstance(v5);
        ** GOTO lbl39
lbl24:
        // 1 sources

        throw new IllegalStateException("Illegal access of private extra");
lbl25:
        // 1 sources

        v7 = this;
        var1_1 = v8;
        v9 = this;
        v10 = v9;
        v11 = v9;
        var2_3 = v9.mFrameOrientation;
        var3_4 = v11.width;
        var4_5 = v10.height;
        try {
            v8 = new CardScanner(this, var2_3, var3_4, var4_5);
            v7.mCardScanner = var1_1;
lbl39:
            // 2 sources

            v12 = this;
            v12.mCardScanner.prepareScanner();
            v12.setPreviewLayout();
            v13 = this;
            v12.orientationListener = new OrientationEventListener((Context)v13, 2){

                public void onOrientationChanged(int n) {
                }
            };
        }
        catch (Exception var1_2) {
            this.handleGeneralExceptionError(var1_2);
        }
    }

    private void handleGeneralExceptionError(Exception exception) {
        Toast toast = Toast.makeText((Context)this, (CharSequence)"Unknown exception", (int)1);
        toast.setGravity(17, 0, -75);
        toast.show();
        this.manualEntryFallbackOrForced = true;
    }

    private void doOrientationChange(int n) {
        CardScanner cardScanner;
        if (n >= 0 && (cardScanner = this.mCardScanner) != null) {
            if ((n += cardScanner.getRotationalOffset()) > 360) {
                n += -360;
            }
            int n2 = -1;
            if (n >= 15 && n <= 345) {
                if (n > 75 && n < 105) {
                    n2 = 90;
                    this.mFrameOrientation = 4;
                } else if (n > 165 && n < 195) {
                    n2 = 180;
                    this.mFrameOrientation = 2;
                } else if (n > 255 && n < 285) {
                    n2 = 270;
                    this.mFrameOrientation = 3;
                }
            } else {
                n2 = 0;
                this.mFrameOrientation = 1;
            }
            if (n2 >= 0 && n2 != this.mLastDegrees) {
                this.mCardScanner.setDeviceOrientation(this.mFrameOrientation);
                this.setDeviceDegrees(n2);
                if (n2 == 90) {
                    this.rotateCustomOverlay(270.0f);
                } else if (n2 == 270) {
                    this.rotateCustomOverlay(90.0f);
                } else {
                    this.rotateCustomOverlay(n2);
                }
            }
            return;
        }
    }

    private void customizeThemeOnUi() {
        CardIOActivity cardIOActivity = this;
        cardIOActivity.mMainLayout.setBackgroundColor(PiaTheme.getUiTheme((Context)this).getCardIOBackgroundColor());
        cardIOActivity.mOverlay.setGuideColor(PiaTheme.getUiTheme((Context)this).getCardIOPreviewFrameColor());
        cardIOActivity.customToolbar.setBackgroundColor(PiaTheme.getUiTheme((Context)this).getToolbarColor());
        cardIOActivity.customToolbar.setTitleTextColor(PiaTheme.getUiTheme((Context)this).getToolbarTitleColor());
        if (!cardIOActivity.suppressManualEntry) {
            GradientDrawable gradientDrawable;
            this.manualEntryButton.setTextColor(PiaTheme.getUiTheme((Context)this).getCardIOButtonTextColor());
            if (PiaInterfaceConfiguration.getInstance().getCardIOButtonBackgroundSelector() != null) {
                gradientDrawable = PiaInterfaceConfiguration.getInstance().getCardIOButtonBackgroundSelector();
            } else {
                GradientDrawable gradientDrawable2;
                gradientDrawable = gradientDrawable2;
                new GradientDrawable().setCornerRadius(8.0f);
            }
            gradientDrawable.setColor(PiaTheme.getUiTheme((Context)this).getCardIOButtonBackgroundColor());
            this.manualEntryButton.setBackground((Drawable)gradientDrawable);
        }
    }

    public static boolean canReadCardWithCamera() {
        try {
            return Util.hardwareSupported();
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)"RuntimeException accessing Util.hardwareSupported()");
            return false;
        }
        catch (CameraUnavailableException cameraUnavailableException) {
            return false;
        }
    }

    public static String sdkVersion() {
        return "2.7.2";
    }

    @Deprecated
    public static Date sdkBuildDate() {
        return new Date();
    }

    public static Bitmap getCapturedCardImage(Intent object) {
        if (object != null && object.hasExtra(EXTRA_CAPTURED_CARD_IMAGE)) {
            BitmapFactory.Options options;
            object = object.getByteArrayExtra(EXTRA_CAPTURED_CARD_IMAGE);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            object = options;
            options = new BitmapFactory.Options();
            return BitmapFactory.decodeStream((InputStream)byteArrayInputStream, null, (BitmapFactory.Options)object);
        }
        return null;
    }

    private void nextActivity() {
        final Intent intent = this.getIntent();
        if (intent != null && intent.getBooleanExtra(EXTRA_SUPPRESS_CONFIRMATION, false)) {
            Intent intent2;
            Intent intent3 = intent2;
            intent2 = new Intent((Context)this, PiaActivity.class);
            CreditCard creditCard = this.mDetectedCard;
            if (creditCard != null) {
                intent3.putExtra(EXTRA_SCAN_RESULT, (Parcelable)creditCard);
                this.mDetectedCard = null;
            }
            Util.writeCapturedCardImageIfNecessary(intent, intent3, this.mOverlay);
            this.setResultAndFinish(RESULT_CONFIRMATION_SUPPRESSED, intent3);
        } else {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    Intent intent3;
                    4 v0 = this;
                    v0.CardIOActivity.this.getWindow().clearFlags(1024);
                    v0.CardIOActivity.this.getWindow().addFlags(512);
                    Intent intent2 = intent3;
                    intent3 = new Intent((Context)CardIOActivity.this, PiaActivity.class);
                    Util.writeCapturedCardImageIfNecessary(v0.intent, intent2, CardIOActivity.this.mOverlay);
                    if (v0.CardIOActivity.this.mOverlay != null) {
                        CardIOActivity.this.mOverlay.markupCard();
                        Bitmap bitmap = markedCardImage;
                        if (bitmap != null && !bitmap.isRecycled()) {
                            markedCardImage.recycle();
                        }
                        markedCardImage = CardIOActivity.this.mOverlay.getCardImage();
                    }
                    if (CardIOActivity.this.mDetectedCard != null) {
                        intent2.putExtra(CardIOActivity.EXTRA_SCAN_RESULT, (Parcelable)CardIOActivity.this.mDetectedCard);
                        CardIOActivity.access$402(CardIOActivity.this, null);
                    } else {
                        intent2.putExtra(CardIOActivity.EXTRA_MANUAL_ENTRY_RESULT, true);
                    }
                    CardIOActivity.this.setResultAndFinish(RESULT_CARD_INFO, intent2);
                }
            };
            new Handler().post(runnable2);
        }
    }

    private void showErrorMessage(String string2) {
        Log.e((String)"card.io", (String)("error display: " + string2));
        Toast.makeText((Context)this, (CharSequence)string2, (int)1).show();
    }

    private boolean restartPreview() {
        this.mDetectedCard = null;
        if (!$assertionsDisabled && this.mPreview == null) {
            throw new AssertionError();
        }
        boolean bl = this.mCardScanner.resumeScanning(this.mPreview.getSurfaceHolder());
        if (bl) {
            this.mUIBar.setVisibility(0);
        }
        return bl;
    }

    private void setDeviceDegrees(int n) {
        Rect rect;
        SurfaceView surfaceView = this.mPreview.getSurfaceView();
        if (surfaceView == null) {
            return;
        }
        CardIOActivity cardIOActivity = this;
        SurfaceView surfaceView2 = surfaceView;
        int n2 = surfaceView2.getWidth();
        this.mGuideFrame = rect = cardIOActivity.mCardScanner.getGuideFrame(n2, surfaceView2.getHeight());
        int n3 = rect.top;
        cardIOActivity.mCardScanner.getGuideFrame(n2, surfaceView2.getHeight()).top = surfaceView.getTop() + n3;
        n3 = cardIOActivity.mGuideFrame.bottom;
        cardIOActivity.mGuideFrame.bottom = surfaceView.getTop() + n3;
        n3 = cardIOActivity.getResources().getConfiguration().screenLayout & 0xF;
        if (n3 == 3 || n3 == 4) {
            this.mGuideFrame.left += 200;
        }
        CardIOActivity cardIOActivity2 = this;
        cardIOActivity2.mOverlay.setSurfaceViewTop(surfaceView.getTop());
        cardIOActivity2.mOverlay.setGuideAndRotation(this.mGuideFrame, n);
        this.mLastDegrees = n;
    }

    private void setPreviewLayout() {
        RelativeLayout.LayoutParams layoutParams;
        CustomToolbar customToolbar;
        CustomToolbar customToolbar2;
        RelativeLayout.LayoutParams layoutParams2;
        RelativeLayout.LayoutParams layoutParams3;
        RelativeLayout.LayoutParams layoutParams4;
        RelativeLayout.LayoutParams layoutParams5;
        FrameLayout frameLayout;
        FrameLayout frameLayout2;
        this.mMainLayout = new FrameLayout((Context)this);
        this.mMainLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        FrameLayout frameLayout3 = frameLayout2 = frameLayout;
        frameLayout3((Context)this);
        frameLayout3.setId(1);
        CardIOActivity cardIOActivity = this;
        CardScanner cardScanner = cardIOActivity.mCardScanner;
        int bl = cardScanner.mPreviewWidth;
        int n = cardScanner.mPreviewHeight;
        this.mPreview = new Preview((Context)cardIOActivity, null, bl, n);
        this.mPreview.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        frameLayout.addView((View)this.mPreview);
        CardIOActivity cardIOActivity2 = this;
        this.mOverlay = new OverlayView(cardIOActivity2, null, Util.deviceSupportsTorch((Context)cardIOActivity2), (Context)this);
        this.mOverlay.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        if (this.getIntent() != null) {
            CardIOActivity cardIOActivity3 = this;
            boolean layoutParams52 = cardIOActivity3.getIntent().getBooleanExtra(EXTRA_USE_CARDIO_LOGO, false);
            cardIOActivity3.mOverlay.setUseCardIOLogo(layoutParams52);
            boolean n2 = cardIOActivity3.getIntent().getBooleanExtra(EXTRA_HIDE_CARDIO_LOGO, true);
            cardIOActivity3.mOverlay.setHideCardIOLogo(n2);
            cardIOActivity3.mOverlay.setScanInstructions(this.getString(R.string.pia_scan_instruction));
        }
        CardIOActivity cardIOActivity4 = this;
        frameLayout2.addView((View)this.mOverlay);
        RelativeLayout.LayoutParams layoutParams6 = layoutParams5 = layoutParams4;
        layoutParams6(-1, -1);
        layoutParams6.addRule(10, -1);
        layoutParams6.addRule(2, 2);
        this.mMainLayout.addView((View)frameLayout2, (ViewGroup.LayoutParams)layoutParams5);
        this.mUIBar = new RelativeLayout((Context)this);
        frameLayout2 = layoutParams3;
        layoutParams3 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams4.addRule(12);
        cardIOActivity4.mUIBar.setLayoutParams((ViewGroup.LayoutParams)frameLayout2);
        cardIOActivity4.mUIBar.setId(2);
        cardIOActivity4.mUIBar.setGravity(81);
        if (!cardIOActivity4.suppressManualEntry) {
            this.manualEntryButton = new PiaButton((Context)this);
            this.manualEntryButton.setId(3);
            if (PiaInterfaceConfiguration.getInstance().getCardIOButtonTextFont() != null) {
                this.manualEntryButton.setTypeface(PiaInterfaceConfiguration.getInstance().getCardIOButtonTextFont());
            }
            CardIOActivity cardIOActivity5 = this;
            cardIOActivity5.manualEntryButton.setText(this.getString(R.string.pia_scan_button_manual_entry));
            cardIOActivity5.manualEntryButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CardIOActivity.this.setResultAndFinish(RESULT_SCAN_SUPPRESSED, new Intent());
                }
            });
            cardIOActivity5.mUIBar.addView((View)this.manualEntryButton);
            cardIOActivity5.manualEntryButton.setMinimumHeight(ViewUtil.typedDimensionValueToPixelsInt("42dip", (Context)this));
            ((RelativeLayout.LayoutParams)cardIOActivity5.manualEntryButton.getLayoutParams()).width = -1;
            ((RelativeLayout.LayoutParams)cardIOActivity5.manualEntryButton.getLayoutParams()).height = -2;
            ((RelativeLayout.LayoutParams)cardIOActivity5.manualEntryButton.getLayoutParams()).addRule(12);
            ViewUtil.setPadding((View)cardIOActivity5.manualEntryButton, "16dip", null, "16dip", null);
            ViewUtil.setMargins((View)cardIOActivity5.manualEntryButton, "8dip", "8dip", "8dip", "8dip");
        }
        CardIOActivity cardIOActivity6 = this;
        FrameLayout frameLayout4 = frameLayout2 = layoutParams2;
        frameLayout4(-1, -2);
        frameLayout4.addRule(12);
        int n2 = (int)(this.getResources().getDisplayMetrics().density * 15.0f + 0.5f);
        layoutParams2.setMargins(0, n2, 0, n2);
        cardIOActivity6.mMainLayout.addView((View)this.mUIBar, (ViewGroup.LayoutParams)frameLayout2);
        if (cardIOActivity6.getIntent() != null) {
            int n3;
            frameLayout2 = this.customOverlayLayout;
            if (frameLayout2 != null) {
                this.mMainLayout.removeView((View)frameLayout2);
                this.customOverlayLayout = null;
            }
            if ((n3 = this.getIntent().getIntExtra(EXTRA_SCAN_OVERLAY_LAYOUT_ID, -1)) != -1) {
                CardIOActivity cardIOActivity7 = this;
                this.customOverlayLayout = new LinearLayout((Context)this);
                this.customOverlayLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                cardIOActivity7.getLayoutInflater().inflate(n3, (ViewGroup)this.customOverlayLayout);
                cardIOActivity7.mMainLayout.addView((View)this.customOverlayLayout);
            }
        }
        CardIOActivity cardIOActivity8 = this;
        CustomToolbar customToolbar3 = customToolbar2 = customToolbar;
        customToolbar3((Context)this);
        this.customToolbar = customToolbar3;
        customToolbar.setTitle(this.getString(R.string.pia_scan_toolbar_title));
        customToolbar2 = layoutParams;
        new RelativeLayout.LayoutParams(-1, this.getActionBarSize()).addRule(12);
        cardIOActivity8.mMainLayout.addView((View)this.customToolbar, (ViewGroup.LayoutParams)customToolbar2);
        cardIOActivity8.setContentView((View)cardIOActivity8.mMainLayout);
        cardIOActivity8.customizeThemeOnUi();
    }

    private void rotateCustomOverlay(float f2) {
        LinearLayout linearLayout = this.customOverlayLayout;
        if (linearLayout != null) {
            RotateAnimation rotateAnimation;
            CardIOActivity cardIOActivity = this;
            float f3 = linearLayout.getWidth() / 2;
            float f4 = cardIOActivity.customOverlayLayout.getHeight() / 2;
            RotateAnimation rotateAnimation2 = rotateAnimation;
            new RotateAnimation(0.0f, f2, f3, f4).setDuration(0L);
            rotateAnimation2.setRepeatCount(0);
            rotateAnimation2.setFillAfter(true);
            cardIOActivity.customOverlayLayout.setAnimation((Animation)rotateAnimation2);
        }
    }

    private void setResultAndFinish(int n, Intent intent) {
        CardIOActivity cardIOActivity = this;
        cardIOActivity.setResult(n, intent);
        markedCardImage = null;
        cardIOActivity.finish();
    }

    public static /* synthetic */ boolean access$002(CardIOActivity cardIOActivity, boolean bl) {
        cardIOActivity.waitingForPermission = bl;
        return bl;
    }

    public static /* synthetic */ CreditCard access$402(CardIOActivity cardIOActivity, CreditCard creditCard) {
        cardIOActivity.mDetectedCard = creditCard;
        return creditCard;
    }

    static {
        $assertionsDisabled = CardIOActivity.class.desiredAssertionStatus() ^ true;
        int n = 13274384 + 1;
        int n2 = n;
        RESULT_CARD_INFO = 13274384;
        RESULT_ENTRY_CANCELED = n;
        int n3 = ++n2 + 1;
        RESULT_SCAN_NOT_AVAILABLE = n2;
        n2 = n3 + 1;
        RESULT_SCAN_SUPPRESSED = n3;
        int n4 = n2 + 1;
        RESULT_CANCEL_PROCESS = n2;
        lastResult = n4 + 1;
        RESULT_CONFIRMATION_SUPPRESSED = n4;
        TAG = "CardIOActivity";
        VIBRATE_PATTERN = new long[]{0L, 70L, 10L, 40L};
        markedCardImage = null;
    }

    /*
     * Unable to fully structure code
     */
    public void onCreate(Bundle var1_1) {
        block12: {
            block11: {
                v0 = this;
                super.onCreate((Bundle)var1_1);
                var2_3 = v0.getActionBar();
                if (var2_3 != null) {
                    var2_3.hide();
                }
                v1 = this;
                v1.getWindow().setSoftInputMode(3);
                v1.getWindow().setFlags(9216, 9216);
                var2_3 = v2;
                v1.getWindowManager().getDefaultDisplay().getSize(new Point());
                v1.width = var2_3.x;
                v1.height = var2_3.y;
                var2_3 = v1.getIntent();
                this.isUserReturning = var2_3.getBooleanExtra("io.card.payment.isUserReturning", false);
                v1.mDetectOnly = var2_3.getBooleanExtra("io.card.payment.suppressScan", false);
                var3_4 = Util.manifestHasConfigChange(v1.getPackageManager().resolveActivity((Intent)var2_3, 65536), CardIOActivity.class);
                if (var3_4 != null) break block12;
                this.suppressManualEntry = var2_3.getBooleanExtra("io.card.payment.suppressManual", false);
                if (var1_1 != null) {
                    this.waitingForPermission = var1_1.getBoolean("io.card.payment.waitingForPermission");
                }
                if (var2_3.getBooleanExtra("io.card.payment.noCamera", false)) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        this.manualEntryFallbackOrForced = true;
                        break block11;
                        break;
                    }
                }
                ** while (!CardScanner.processorSupported())
lbl27:
                // 2 sources

                if (Build.VERSION.SDK_INT < 23) ** GOTO lbl49
                if (this.waitingForPermission) break block11;
                if (this.checkSelfPermission("android.permission.CAMERA") != -1) ** GOTO lbl45
                this.waitingForPermission = true;
                if (this.isUserReturning) ** GOTO lbl43
                v3 = this;
                v4 = new String[1];
                var1_1 = v4;
                try {
                    v4[0] = "android.permission.CAMERA";
                    v3.requestPermissions(var1_1, 11);
                    break block11;
lbl43:
                    // 1 sources

                    this.showDeniedPermissionDialog();
                    break block11;
lbl45:
                    // 1 sources

                    v5 = this;
                    v5.checkCamera();
                    v5.android23AndAboveHandleCamera();
                    break block11;
lbl49:
                    // 1 sources

                    v6 = this;
                    v6.checkCamera();
                    v6.android22AndBelowHandleCamera();
                }
                catch (Exception var1_2) {
                    this.handleGeneralExceptionError(var1_2);
                }
            }
            return;
        }
        throw new RuntimeException(var3_4);
    }

    public void attachBaseContext(Context context) {
        if (PiaInterfaceConfiguration.getInstance().getPiaLanguage() != null) {
            super.attachBaseContext(d.a(context));
        } else {
            super.attachBaseContext(context);
        }
    }

    public void onResume() {
        CardIOActivity cardIOActivity = this;
        super.onResume();
        if (!cardIOActivity.waitingForPermission) {
            if (this.manualEntryFallbackOrForced) {
                if (this.suppressManualEntry) {
                    this.finishIfSuppressManualEntry();
                    return;
                }
                this.nextActivity();
                return;
            }
            if (this.isUserReturning && Build.VERSION.SDK_INT >= 23) {
                if (this.checkSelfPermission("android.permission.CAMERA") == -1) {
                    Intent intent;
                    int n = RESULT_CONFIRMATION_SUPPRESSED;
                    Intent intent2 = intent;
                    intent = new Intent();
                    this.setResultAndFinish(n, intent2);
                    return;
                }
                CardIOActivity cardIOActivity2 = this;
                cardIOActivity2.checkCamera();
                cardIOActivity2.android23AndAboveHandleCamera();
            }
            Util.logNativeMemoryStats();
            if (!this.restartPreview()) {
                this.nextActivity();
            } else {
                this.setFlashOn(false);
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        CardIOActivity cardIOActivity = this;
        super.onSaveInstanceState(bundle);
        bundle.putBoolean(BUNDLE_WAITING_FOR_PERMISSION, cardIOActivity.waitingForPermission);
    }

    public void onPause() {
        CardIOActivity cardIOActivity = cardScanner;
        super.onPause();
        OrientationEventListener orientationEventListener = cardIOActivity.orientationListener;
        if (orientationEventListener != null) {
            orientationEventListener.disable();
        }
        CardIOActivity cardIOActivity2 = cardScanner;
        cardIOActivity2.setFlashOn(false);
        CardScanner cardScanner = cardIOActivity2.mCardScanner;
        if (cardScanner != null) {
            cardScanner.pauseScanning();
        }
    }

    public void onDestroy() {
        this.mOverlay = null;
        Object object = this.orientationListener;
        if (object != null) {
            object.disable();
        }
        CardIOActivity cardIOActivity = this;
        cardIOActivity.setFlashOn(false);
        object = cardIOActivity.mCardScanner;
        if (object != null) {
            ((CardScanner)object).endScanning();
            this.mCardScanner = null;
        }
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        if (n == 11) {
            this.waitingForPermission = false;
            if (nArray.length > 0 && nArray[0] == 0) {
                this.showCameraScannerOverlay();
            } else {
                this.manualEntryFallbackOrForced = true;
            }
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 10) {
            if (n2 != RESULT_CARD_INFO && n2 != RESULT_ENTRY_CANCELED && !cardIOActivity.manualEntryFallbackOrForced) {
                CardIOActivity cardIOActivity = cardIOActivity.mUIBar;
                if (cardIOActivity != null) {
                    cardIOActivity.setVisibility(0);
                }
            } else {
                cardIOActivity.setResultAndFinish(n2, intent);
            }
        }
    }

    public void onBackPressed() {
        Intent intent;
        int n = RESULT_CANCEL_PROCESS;
        Intent intent2 = intent;
        intent = new Intent();
        this.setResultAndFinish(n, intent2);
    }

    public void onFirstFrame() {
        DetectionInfo detectionInfo;
        CardIOActivity cardIOActivity = object;
        SurfaceView surfaceView = cardIOActivity.mPreview.getSurfaceView();
        OverlayView overlayView = cardIOActivity.mOverlay;
        if (overlayView != null) {
            Rect rect;
            OverlayView overlayView2 = overlayView;
            overlayView = rect;
            SurfaceView surfaceView2 = surfaceView;
            int n = surfaceView2.getLeft();
            int n2 = surfaceView2.getTop();
            int n3 = surfaceView2.getRight();
            int n4 = surfaceView2.getBottom();
            rect = new Rect(n, n2, n3, n4);
            overlayView2.setCameraPreviewRect((Rect)overlayView);
        }
        CardIOActivity cardIOActivity2 = object;
        cardIOActivity2.mFrameOrientation = 1;
        cardIOActivity2.setDeviceDegrees(0);
        Object object = detectionInfo;
        detectionInfo = new DetectionInfo();
        cardIOActivity2.onEdgeUpdate((DetectionInfo)object);
    }

    public void onEdgeUpdate(DetectionInfo detectionInfo) {
        this.mOverlay.setDetectionInfo(detectionInfo);
    }

    public void onCardDetected(Bitmap bitmap, DetectionInfo object) {
        Matrix matrix;
        int n;
        try {
            ((Vibrator)this.getSystemService("vibrator")).vibrate(VIBRATE_PATTERN, -1);
        }
        catch (Exception exception) {
            Log.w((String)"card.io", (String)"Exception while attempting to vibrate: ", (Throwable)exception);
        }
        catch (SecurityException securityException) {
            Log.e((String)"card.io", (String)"Could not activate vibration feedback. Please add <uses-permission android:name=\"android.permission.VIBRATE\" /> to your application's manifest.");
        }
        CardIOActivity cardIOActivity = this;
        cardIOActivity.mCardScanner.pauseScanning();
        cardIOActivity.mUIBar.setVisibility(4);
        if (((DetectionInfo)object).predicted()) {
            object = ((DetectionInfo)object).creditCard();
            this.mDetectedCard = object;
            this.mOverlay.setDetectedCard((CreditCard)object);
        }
        float f2 = (n = this.mFrameOrientation) != 1 && n != 2 ? (float)this.mGuideFrame.right / 428.0f * 1.15f : (float)this.mGuideFrame.right / 428.0f * 0.95f;
        CardIOActivity cardIOActivity2 = this;
        Bitmap bitmap2 = bitmap;
        bitmap = matrix;
        bitmap();
        matrix.postScale(f2, f2);
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n2, (int)n3, (Matrix)bitmap, (boolean)false);
        cardIOActivity2.mOverlay.setBitmap(bitmap);
        if (cardIOActivity2.mDetectOnly) {
            Intent intent;
            CardIOActivity cardIOActivity3 = this;
            bitmap = intent;
            intent = new Intent();
            Util.writeCapturedCardImageIfNecessary(cardIOActivity3.getIntent(), (Intent)bitmap, this.mOverlay);
            cardIOActivity3.setResultAndFinish(RESULT_SCAN_SUPPRESSED, (Intent)bitmap);
        } else {
            this.nextActivity();
        }
    }

    public void toggleFlash() {
        CardIOActivity cardIOActivity = this;
        cardIOActivity.setFlashOn(cardIOActivity.mCardScanner.isFlashOn() ^ true);
    }

    public void setFlashOn(boolean bl) {
        if (this.mPreview != null && this.mOverlay != null && this.mCardScanner.setFlashOn(bl)) {
            this.mOverlay.setTorchOn(bl);
        }
    }

    public void triggerAutoFocus() {
        this.mCardScanner.triggerAutoFocus(true);
    }

    public int getActionBarSize() {
        CardIOActivity cardIOActivity = cardIOActivity.getTheme().obtainStyledAttributes(new int[]{16843499});
        int n = (int)cardIOActivity.getDimension(0, 0.0f);
        cardIOActivity.recycle();
        return n;
    }

    public Rect getTorchRect() {
        Object object = object.mOverlay;
        if (object == null) {
            return null;
        }
        return ((OverlayView)((Object)object)).getTorchRect();
    }

    public void onConfigurationChanged(Configuration configuration) {
        CardIOActivity cardIOActivity = this;
        super.onConfigurationChanged(configuration);
        cardIOActivity.customizeThemeOnUi();
    }
}

