/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import eu.nets.pia.cardio.CardType;
import eu.nets.pia.cardio.CreditCardNumber;
import eu.nets.pia.cardio.StringHelper;
import eu.nets.pia.cardio.Validator;

class CardNumberValidator
implements Validator {
    static final int[] AMEX_SPACER = new int[]{4, 11};
    static final int[] NORMAL_SPACER = new int[]{4, 9, 14};
    private String numberString;
    private int spacerToDelete;

    public CardNumberValidator() {
    }

    public CardNumberValidator(String string2) {
        this.numberString = string2;
    }

    public void afterTextChanged(Editable editable) {
        this.numberString = StringHelper.getDigitsOnlyString(editable.toString());
        CardType cardType = CardType.fromCardNumber(this.numberString);
        int n = this.spacerToDelete;
        if (n > 1) {
            int n2 = n - 1;
            this.spacerToDelete = 0;
            if (n > n2) {
                editable.delete(n2, n);
            }
        }
        for (int i = 0; i < editable.length(); ++i) {
            n = editable.charAt(i);
            if ((cardType.numberLength() != 15 || i != 4 && i != 11) && (cardType.numberLength() != 16 && cardType.numberLength() != 14 || i != 4 && i != 9 && i != 14)) {
                if (n != 32) continue;
                editable.delete(i, i + 1);
                --i;
                continue;
            }
            if (n == 32) continue;
            editable.insert(i, (CharSequence)" ");
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    @Override
    public boolean hasFullLength() {
        if (TextUtils.isEmpty((CharSequence)((CardNumberValidator)((Object)cardType)).numberString)) {
            return false;
        }
        CardNumberValidator cardNumberValidator = cardType;
        CardType cardType = CardType.fromCardNumber(cardNumberValidator.numberString);
        return cardNumberValidator.numberString.length() == cardType.numberLength();
    }

    @Override
    public boolean isValid() {
        if (!this.hasFullLength()) {
            return false;
        }
        return CreditCardNumber.passesLuhnChecksum(this.numberString);
    }

    @Override
    public String getValue() {
        return this.numberString;
    }

    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        SpannableStringBuilder spannableStringBuilder;
        String string2 = StringHelper.getDigitsOnlyString(new SpannableStringBuilder((CharSequence)spanned).replace(n3, n4, charSequence, n, n2).toString());
        n = CardType.fromCardNumber(string2).numberLength();
        if (string2.length() > n) {
            return "";
        }
        SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
        spannableStringBuilder = new SpannableStringBuilder(charSequence);
        int[] nArray = n == 15 ? AMEX_SPACER : NORMAL_SPACER;
        n4 -= n3;
        for (int i = 0; i < nArray.length; ++i) {
            int n5;
            if (charSequence.length() == 0 && n3 == nArray[i] && spanned.charAt(n3) == ' ') {
                this.spacerToDelete = nArray[i];
            }
            if (n3 - n4 > (n5 = nArray[i]) || n3 + n2 - n4 < n5 || (n5 -= n3) != n2 && (n5 < 0 || n5 >= n2 || spannableStringBuilder2.charAt(n5) == ' ')) continue;
            spannableStringBuilder2.insert(n5, (CharSequence)" ");
            ++n2;
        }
        return spannableStringBuilder2;
    }
}

